export type Json =
  | string
  | number
  | boolean
  | null
  | { [key: string]: Json | undefined }
  | Json[]

export interface Database {
  public: {
    Tables: {
      profiles: {
        Row: {
          id: string
          name: string | null
          email: string
          role: 'admin' | 'manager' | 'user'
          avatar_url: string | null
          created_at: string
          updated_at: string
        }
        Insert: {
          id: string
          name?: string | null
          email: string
          role?: 'admin' | 'manager' | 'user'
          avatar_url?: string | null
          created_at?: string
          updated_at?: string
        }
        Update: {
          id?: string
          name?: string | null
          email?: string
          role?: 'admin' | 'manager' | 'user'
          avatar_url?: string | null
          created_at?: string
          updated_at?: string
        }
      }
      companies: {
        Row: {
          id: string
          name: string
          industry: string | null
          website: string | null
          size: string | null
          location: string | null
          logo_url: string | null
          created_at: string
          updated_at: string | null
          created_by: string | null
        }
        Insert: {
          id?: string
          name: string
          industry?: string | null
          website?: string | null
          size?: string | null
          location?: string | null
          logo_url?: string | null
          created_at?: string
          updated_at?: string | null
          created_by?: string | null
        }
        Update: {
          id?: string
          name?: string
          industry?: string | null
          website?: string | null
          size?: string | null
          location?: string | null
          logo_url?: string | null
          created_at?: string
          updated_at?: string | null
          created_by?: string | null
        }
      }
      contacts: {
        Row: {
          id: string
          name: string
          email: string | null
          phone: string | null
          company_id: string | null
          position: string | null
          status: string
          notes: string | null
          avatar_url: string | null
          tags: string[] | null
          created_at: string
          updated_at: string | null
          created_by: string | null
          last_activity: string | null
        }
        Insert: {
          id?: string
          name: string
          email?: string | null
          phone?: string | null
          company_id?: string | null
          position?: string | null
          status?: string
          notes?: string | null
          avatar_url?: string | null
          tags?: string[] | null
          created_at?: string
          updated_at?: string | null
          created_by?: string | null
          last_activity?: string | null
        }
        Update: {
          id?: string
          name?: string
          email?: string | null
          phone?: string | null
          company_id?: string | null
          position?: string | null
          status?: string
          notes?: string | null
          avatar_url?: string | null
          tags?: string[] | null
          created_at?: string
          updated_at?: string | null
          created_by?: string | null
          last_activity?: string | null
        }
      }
      deals: {
        Row: {
          id: string
          title: string
          value: number | null
          company_id: string | null
          contact_id: string | null
          stage_id: string
          priority: string
          description: string | null
          owner_id: string
          expected_close_date: string | null
          created_at: string
          updated_at: string
          closed_at: string | null
        }
        Insert: {
          id?: string
          title: string
          value?: number | null
          company_id?: string | null
          contact_id?: string | null
          stage_id: string
          priority?: string
          description?: string | null
          owner_id: string
          expected_close_date?: string | null
          created_at?: string
          updated_at?: string
          closed_at?: string | null
        }
        Update: {
          id?: string
          title?: string
          value?: number | null
          company_id?: string | null
          contact_id?: string | null
          stage_id?: string
          priority?: string
          description?: string | null
          owner_id?: string
          expected_close_date?: string | null
          created_at?: string
          updated_at?: string
          closed_at?: string | null
        }
      }
      pipeline_stages: {
        Row: {
          id: string
          title: string
          color: string
          order: number
          created_at: string
          updated_at: string
        }
        Insert: {
          id: string
          title: string
          color: string
          order: number
          created_at?: string
          updated_at?: string
        }
        Update: {
          id?: string
          title?: string
          color?: string
          order?: number
          created_at?: string
          updated_at?: string
        }
      }
      activities: {
        Row: {
          id: string
          type: string
          description: string
          timestamp: string
          user_id: string
          related_id: string | null
          related_type: string | null
          metadata: any | null
          created_at: string
        }
        Insert: {
          id?: string
          type: string
          description: string
          timestamp?: string
          user_id: string
          related_id?: string | null
          related_type?: string | null
          metadata?: any | null
          created_at?: string
        }
        Update: {
          id?: string
          type?: string
          description?: string
          timestamp?: string
          user_id?: string
          related_id?: string | null
          related_type?: string | null
          metadata?: any | null
          created_at?: string
        }
      }
      tasks: {
        Row: {
          id: string
          title: string
          description: string | null
          due_date: string
          priority: string
          related_id: string | null
          related_type: string | null
          status: string
          assigned_to: string | null
          created_at: string
          updated_at: string | null
          completed_at: string | null
          type: string | null
          created_by: string
        }
        Insert: {
          id?: string
          title: string
          description?: string | null
          due_date: string
          priority: string
          related_id?: string | null
          related_type?: string | null
          status: string
          assigned_to?: string | null
          created_at?: string
          updated_at?: string | null
          completed_at?: string | null
          type?: string | null
          created_by: string
        }
        Update: {
          id?: string
          title?: string
          description?: string | null
          due_date?: string
          priority?: string
          related_id?: string | null
          related_type?: string | null
          status?: string
          assigned_to?: string | null
          created_at?: string
          updated_at?: string | null
          completed_at?: string | null
          type?: string | null
          created_by?: string
        }
      }
      notifications: {
        Row: {
          id: string
          user_id: string
          type: string
          message: string
          read: boolean
          related_id: string | null
          related_type: string | null
          created_at: string
        }
        Insert: {
          id?: string
          user_id: string
          type: string
          message: string
          read?: boolean
          related_id?: string | null
          related_type?: string | null
          created_at?: string
        }
        Update: {
          id?: string
          user_id?: string
          type?: string
          message?: string
          read?: boolean
          related_id?: string | null
          related_type?: string | null
          created_at?: string
        }
      }
    }
    Views: {
      [_ in never]: never
    }
    Functions: {
      [_ in never]: never
    }
    Enums: {
      [_ in never]: never
    }
  }
} 