# Amazona - Amazon Style E-Commerce (Next.js + Supabase)

A modern, production-ready Amazon-style e-commerce website built with Next.js 13 App Router, Supabase, and Tailwind CSS.

## Features

- Modern responsive UI with glassmorphism and micro-animations
- Product listing grid with Unsplash images
- Product detail pages
- Loading skeletons and error handling
- Toast notifications for user feedback
- Reusable, feature-based component architecture
- Strict TypeScript and performance best practices
- Ready-to-extend with authentication and cart features

## Tech Stack
- [Next.js 13+ (App Router)](https://nextjs.org/)
- [Supabase](https://supabase.com/) (PostgreSQL)
- [Tailwind CSS](https://tailwindcss.com/)
- [Heroicons, Headless UI, React Hot Toast]

## Setup Instructions

1. **Clone the Repository**
   ```sh
   git clone https://github.com/your-org/amazona-next-supabase.git
   cd amazona-next-supabase
   ```
2. **Install Dependencies**
   ```sh
   npm install
   # or
   yarn install
   ```
3. **Configure Environment Variables**
   Copy `.env.local.example` to `.env.local` and fill in your Supabase project credentials:
   ```sh
   cp .env.local.example .env.local
   ```
4. **Run Database Migrations**
   - Go to the [Supabase SQL Editor](https://app.supabase.com/project/_/sql) and apply the migrations from the `/migrations` folder in order.

5. **Start the Dev Server**
   ```sh
   npm run dev
   # or
   yarn dev
   ```

6. **Open the App**
   Visit [http://localhost:3000](http://localhost:3000) in your browser.

## Environment Variables

- `NEXT_PUBLIC_SUPABASE_URL`: Your Supabase project URL
- `NEXT_PUBLIC_SUPABASE_ANON_KEY`: Supabase public anon key

## Project Structure

- `/src/app/` - Next.js App Router pages
- `/src/components/` - UI and product components
- `/src/features/` - Feature modules (cart, checkout, etc.)
- `/src/types/` - TypeScript types
- `/src/utils/` - Utility functions
- `/src/config/` - Configuration
- `/src/styles/` - Global styles

## Scripts
- `dev`: Run development server
- `build`: Build for production
- `start`: Start production server
- `lint`: Run ESLint
- `format`: Run Prettier
- `test`: Run Jest tests

## Deployment

1. Deploy to [Vercel](https://vercel.com/) or your preferred platform.
2. Set environment variables in the dashboard.
3. Apply SQL migrations to your Supabase project.

## API Documentation

- `/products` - Get all products
- `/products/:id` - Get product detail

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md).

## Security

See [SECURITY.md](SECURITY.md).
