-- 002_schema_setup.sql: Core E-Commerce Schema
BEGIN;
-- Products (content_items)
CREATE TABLE IF NOT EXISTS public.content_items (
  id UUID PRIMARY KEY DEFAULT uuid_generate_v4(),
  title TEXT NOT NULL,
  description TEXT NOT NULL,
  price NUMERIC(10,2) NOT NULL CHECK (price >= 0),
  image_url TEXT NOT NULL,
  category TEXT NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT now()
);

-- Indexing for performance
CREATE INDEX IF NOT EXISTS idx_content_items_category ON public.content_items (category);
CREATE INDEX IF NOT EXISTS idx_content_items_created_at ON public.content_items (created_at DESC);

-- Enable RLS on content_items (products)
ALTER TABLE public.content_items ENABLE ROW LEVEL SECURITY;
-- Anyone can select (public read-only)
CREATE POLICY "Public can read products" ON public.content_items
  FOR SELECT USING (true);

-- Only admin can insert/update/delete (example, for later extension)
-- REVOKE ALL ON public.content_items FROM PUBLIC;
COMMIT;
