-- 004_products_schema.sql: E-commerce Products Setup
BEGIN;

-- Alter existing content_items table to add additional e-commerce fields
ALTER TABLE public.content_items 
  ADD COLUMN IF NOT EXISTS in_stock BOOLEAN DEFAULT TRUE,
  ADD COLUMN IF NOT EXISTS stock_quantity INTEGER DEFAULT 100,
  ADD COLUMN IF NOT EXISTS sku VARCHAR(100) UNIQUE,
  ADD COLUMN IF NOT EXISTS brand VARCHAR(100),
  ADD COLUMN IF NOT EXISTS featured BOOLEAN DEFAULT FALSE,
  ADD COLUMN IF NOT EXISTS discount_percent INTEGER DEFAULT 0 CHECK (discount_percent >= 0 AND discount_percent <= 100),
  ADD COLUMN IF NOT EXISTS attributes JSONB;

-- Indexes for better performance
CREATE INDEX IF NOT EXISTS idx_products_price ON public.content_items(price);

-- Enable Row Level Security
ALTER TABLE public.content_items ENABLE ROW LEVEL SECURITY;

-- Policies for secure access
-- Allow authenticated users to modify products for now
-- You can restrict this later after setting up admin roles
CREATE POLICY "Authenticated users can insert products"
    ON public.content_items
    FOR INSERT
    TO authenticated
    WITH CHECK (true);

CREATE POLICY "Authenticated users can update products"
    ON public.content_items
    FOR UPDATE
    TO authenticated
    USING (true);

CREATE POLICY "Authenticated users can delete products"
    ON public.content_items
    FOR DELETE
    TO authenticated
    USING (true);

-- Function to automatically update the updated_at timestamp
CREATE OR REPLACE FUNCTION public.handle_updated_at()
RETURNS TRIGGER AS $$
BEGIN
    NEW.updated_at = now();
    RETURN NEW;
END;
$$ language 'plpgsql';

-- Trigger to automatically update updated_at
CREATE TRIGGER handle_products_updated_at
    BEFORE UPDATE ON public.content_items
    FOR EACH ROW
    EXECUTE FUNCTION public.handle_updated_at();

-- Sample Products Data with Unsplash Images
INSERT INTO public.content_items (id, title, description, price, image_url, category, brand, sku, stock_quantity, featured)
VALUES
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000001', 'Premium Wireless Headphones', 'High-quality over-ear headphones with noise cancellation and premium sound.', 299.99, 'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=400&h=400&q=80', 'Electronics', 'SoundMaster', 'SM-WH-001', 50, TRUE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000002', 'Smart Fitness Watch', 'Track your workouts, heart rate, and sleep with this advanced fitness tracker.', 179.99, 'https://images.unsplash.com/photo-1523275335684-37898b6baf30?w=400&h=400&q=80', 'Wearables', 'FitTech', 'FT-SW-002', 75, TRUE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000003', 'Ultralight Laptop', 'Powerful, thin and lightweight laptop for professionals on the go.', 1299.99, 'https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=400&h=400&q=80', 'Computers', 'TechPro', 'TP-UL-003', 25, TRUE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000004', 'Digital Camera Kit', 'Professional-grade digital camera with multiple lenses and accessories.', 849.99, 'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=400&h=400&q=80', 'Photography', 'OptixPro', 'OP-DC-004', 15, FALSE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000005', 'Smart Home Speaker', 'Voice-controlled smart speaker with integrated virtual assistant.', 129.99, 'https://images.unsplash.com/photo-1545454675-3531b543be5d?w=400&h=400&q=80', 'Smart Home', 'HomeTech', 'HT-SS-005', 100, FALSE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000006', 'Gaming Console', 'Next-generation gaming console with 4K graphics and 1TB storage.', 499.99, 'https://images.unsplash.com/photo-1593305841991-05c297ba4575?w=400&h=400&q=80', 'Gaming', 'GameSphere', 'GS-GC-006', 30, TRUE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000007', 'Wireless Earbuds', 'Compact wireless earbuds with charging case and water resistance.', 149.99, 'https://images.unsplash.com/photo-1572569511254-d8f925fe2cbb?w=400&h=400&q=80', 'Audio', 'SoundMaster', 'SM-WE-007', 120, FALSE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000008', 'Ergonomic Office Chair', 'Comfortable ergonomic chair for long working hours with adjustable features.', 249.99, 'https://images.unsplash.com/photo-1580480055273-228ff5388ef8?w=400&h=400&q=80', 'Office', 'ErgoComfort', 'EC-OC-008', 40, FALSE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000009', 'Professional Drawing Tablet', 'High-precision drawing tablet for digital artists and designers.', 399.99, 'https://images.unsplash.com/photo-1561116041-565d1b34750a?w=400&h=400&q=80', 'Creativity', 'ArtTech', 'AT-DT-009', 35, FALSE),
  
  ('bdf8c3bc-1b9b-4e3c-8c4d-aaa100000010', 'Smart Coffee Maker', 'Programmable coffee maker with smartphone control and multiple brewing options.', 199.99, 'https://images.unsplash.com/photo-1517142089942-ba376ce32a2e?w=400&h=400&q=80', 'Kitchen', 'SmartBrew', 'SB-CM-010', 60, TRUE);

COMMIT;