import { getSupabaseServerClient } from '@/config/supabase-server';
import ProfileCard from '@/components/account/ProfileCard';

export default async function AccountPage() {
  const supabase = getSupabaseServerClient();
  const {
    data: { session }
  } = await supabase.auth.getSession();
  if (!session) {
    // Middleware should handle redirect, but double check
    return null;
  }
  const { data: profile } = await supabase
    .from('profiles')
    .select('*')
    .eq('id', session.user.id)
    .single();

  return (
    <section className="max-w-lg mx-auto px-4 py-12 min-h-[400px] flex flex-col items-center justify-center">
      <ProfileCard session={session} profile={profile} />
    </section>
  );
}
