export default function AuthError() {
  return (
    <section className="min-h-[70vh] flex flex-col items-center justify-center">
      <div className="rounded-2xl bg-background/90 shadow-glass px-8 py-10 text-center border border-muted max-w-md">
        <h1 className="font-heading text-2xl font-bold mb-4 text-red-600">Authentication Error</h1>
        <p className="text-muted-foreground mb-4">There was a problem with your authentication request. Please try again or contact support.</p>
        <a href="/auth/login" className="inline-block px-6 py-2 rounded-lg bg-primary text-primary-foreground font-semibold shadow-card hover:bg-secondary transition-colors">Back to login</a>
      </div>
    </section>
  );
}
