import type { ReactNode } from 'react';
import Link from 'next/link';

export default function AuthLayout({ children }: { children: ReactNode }) {
  return (
    <section className="min-h-[80vh] flex flex-col items-center justify-center bg-gradient-hero py-12">
      <div className="w-full max-w-md rounded-2xl bg-background/90 shadow-glass px-6 py-8 flex flex-col gap-6 border border-muted">
        <Link href="/" className="block text-center font-heading text-2xl font-bold mb-2 bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent">
          Amazona
        </Link>
        {children}
      </div>
    </section>
  );
}
