import '@/styles/globals.css';
import dynamic from 'next/dynamic';
import type { ReactNode } from 'react';
import Navbar from '@/components/layout/Navbar';
import Footer from '@/components/layout/Footer';
import { CartProvider } from '@/features/cart/CartContext';

const ToastProvider = dynamic(() => import('@/components/ui/ToastProvider'), { ssr: false });

export const metadata = {
  title: 'Amazon Style E-Commerce',
  description: 'Modern Amazon-style e-commerce built with Next.js and Supabase'
};

export default function RootLayout({ children }: { children: ReactNode }) {
  return (
    <html lang="en">
      <body className="bg-background text-foreground min-h-screen flex flex-col">
        <ToastProvider />
        <CartProvider>
          <Navbar />
          <main className="flex-1 flex flex-col bg-gradient-hero">
            {children}
          </main>
          <Footer />
        </CartProvider>
      </body>
    </html>
  );
}
