"use client";
import { NextRequest, NextResponse } from 'next/server';
import { createMiddlewareClient } from '@supabase/auth-helpers-nextjs';
import type { Database } from '@/types/supabase';

export async function middleware(req: NextRequest) {
  const res = NextResponse.next();
  const supabase = createMiddlewareClient<Database>({ req, res });
  const {
    data: { session }
  } = await supabase.auth.getSession();

  // Protect /account route
  if (req.nextUrl.pathname.startsWith('/account') && !session) {
    return NextResponse.redirect(new URL('/auth/login', req.url));
  }
  // Prevent authenticated users from accessing /auth
  if (req.nextUrl.pathname.startsWith('/auth') && session) {
    return NextResponse.redirect(new URL('/account', req.url));
  }
  return res;
}

export const config = {
  matcher: ['/account/:path*', '/auth/:path*']
};
