"use client";
import { useEffect, useState } from 'react';
import { getSupabaseClient } from '@/config/supabase';
import type { Tables } from '@/types/supabase';
import ProductGrid from '@/components/products/ProductGrid';
import HeroSection from '@/components/layout/HeroSection';
import FeaturesSection from '@/components/layout/FeaturesSection';
import FaqSection from '@/components/layout/FaqSection';
import LoadingSkeleton from '@/components/ui/LoadingSkeleton';
import toast from 'react-hot-toast';

export default function HomePage() {
  const [products, setProducts] = useState<Tables['content_items'][] | null>(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState<string | null>(null);

  useEffect(() => {
    setLoading(true);
    setError(null);
    getSupabaseClient()
      .from('content_items')
      .select('*')
      .order('created_at', { ascending: false })
      .then(({ data, error }) => {
        if (error) {
          setError('Failed to load products.');
          toast.error('Failed to load products.');
        } else {
          setProducts(data ?? []);
        }
      })
      .catch(() => {
        setError('Unable to connect to store.');
        toast.error('Unable to connect to store.');
      })
      .finally(() => setLoading(false));
  }, []);

  return (
    <>
      <HeroSection />
      <FeaturesSection />
      <section className="max-w-7xl mx-auto px-4 py-12">
        <h2 className="text-3xl font-heading font-bold mb-8 text-center">
          Latest Products
        </h2>
        {loading ? (
          <LoadingSkeleton type="grid" />
        ) : error ? (
          <div className="text-center text-red-600 my-8">{error}</div>
        ) : products && products.length > 0 ? (
          <ProductGrid products={products} />
        ) : (
          <div className="text-center text-muted-foreground my-8">No products found.</div>
        )}
      </section>
      <FaqSection />
    </>
  );
}
