const faqs = [
  {
    question: 'How fast is shipping?',
    answer: 'Most orders are delivered within 1-3 business days, depending on your location.'
  },
  {
    question: 'Is my payment information secure?',
    answer: 'Yes, we use industry-standard encryption and never store your payment details.'
  },
  {
    question: 'Can I return products?',
    answer: 'Absolutely! We offer a 30-day hassle-free return policy on all items.'
  },
  {
    question: 'Do you have customer support?',
    answer: 'Our support team is available 24/7 to assist you with any questions.'
  }
];

export default function FaqSection() {
  return (
    <section id="faq" className="py-16 bg-background">
      <div className="max-w-3xl mx-auto px-4">
        <h2 className="text-2xl md:text-3xl font-heading font-bold mb-8 text-center">
          Frequently Asked Questions
        </h2>
        <div className="space-y-6">
          {faqs.map((faq, i) => (
            <div
              key={faq.question}
              className="rounded-xl bg-muted/80 shadow-card p-6 transition-all duration-150"
            >
              <h3 className="font-semibold text-lg mb-2 text-primary">
                {faq.question}
              </h3>
              <p className="text-muted-foreground text-base">
                {faq.answer}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
