import { BoltIcon, ShieldCheckIcon, TruckIcon } from '@heroicons/react/24/outline';

const features = [
  {
    title: 'Lightning Fast Shipping',
    description: 'Get your orders delivered at record speed with our world-class logistics.',
    icon: TruckIcon
  },
  {
    title: 'Secure Shopping',
    description: 'Shop with confidence knowing your data and payments are protected.',
    icon: ShieldCheckIcon
  },
  {
    title: 'Best Prices',
    description: 'Enjoy unbeatable deals and exclusive discounts on all your favorite products.',
    icon: BoltIcon
  }
];

export default function FeaturesSection() {
  return (
    <section className="py-12 bg-background/60 border-b border-muted">
      <div className="max-w-6xl mx-auto px-4">
        <div className="flex flex-col md:flex-row items-center justify-center gap-8 md:gap-16">
          {features.map((feature, i) => (
            <div
              key={feature.title}
              className="flex flex-col items-center text-center md:text-left md:items-start gap-3"
            >
              <feature.icon className="w-12 h-12 text-primary mb-2 animate-fade-in" />
              <h3 className="font-heading text-xl font-semibold mb-1">
                {feature.title}
              </h3>
              <p className="text-muted-foreground text-base">
                {feature.description}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
