import Image from 'next/image';
import Link from 'next/link';

export default function HeroSection() {
  return (
    <section className="relative bg-gradient-hero py-20 md:py-32 flex items-center justify-center">
      <div className="max-w-5xl mx-auto flex flex-col md:flex-row items-center gap-10 px-4">
        <div className="flex-1 text-center md:text-left">
          <h1 className="text-4xl md:text-5xl font-heading font-bold mb-4 bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent animate-fade-in-down">
            The Next Generation E-Commerce Experience
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 animate-fade-in-up">
            Shop the latest products with unbeatable prices, fast shipping, and a sleek modern interface.
          </p>
          <Link
            href="#products"
            className="inline-block px-8 py-3 rounded-lg bg-primary text-primary-foreground font-semibold shadow-card hover:scale-105 hover:bg-secondary transition-all duration-150 animate-fade-in-up"
          >
            Shop Now
          </Link>
        </div>
        <div className="flex-1 flex justify-center animate-fade-in">
          <Image
            src="https://images.unsplash.com/photo-1607082349566-187342175e2f?w=800&q=80"
            alt="Modern Shopping Experience"
            width={500}
            height={500}
            className="rounded-3xl shadow-glass object-cover border border-muted"
            priority
          />
        </div>
      </div>
    </section>
  );
}
