"use client";
import Link from 'next/link';
import { useEffect, useState } from 'react';
import { getSupabaseClient } from '@/config/supabase';
import { useRouter } from 'next/navigation';
import { UserCircleIcon } from '@heroicons/react/24/solid';

export default function UserMenu() {
  const router = useRouter();
  const [session, setSession] = useState<any | null>(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const supabase = getSupabaseClient();
    supabase.auth.getSession().then(({ data }) => {
      setSession(data.session);
      setLoading(false);
    });
    // Listen for login/logout events
    const { data: listener } = supabase.auth.onAuthStateChange((_event, session) => {
      setSession(session);
    });
    return () => {
      listener.subscription.unsubscribe();
    };
  }, []);

  if (loading) {
    return <div className="w-8 h-8 rounded-full bg-muted animate-pulse" />;
  }

  if (!session) {
    return (
      <Link
        href="/auth/login"
        className="px-4 py-1.5 rounded-lg bg-primary text-primary-foreground font-semibold shadow-card hover:bg-secondary hover:scale-105 transition-all duration-150"
      >
        Sign In
      </Link>
    );
  }

  return (
    <Link
      href="/account"
      className="flex items-center gap-2 px-3 py-1.5 rounded-lg bg-muted text-foreground font-semibold hover:bg-background hover:scale-105 transition-all duration-150 border border-muted-foreground shadow-card"
    >
      <UserCircleIcon className="w-6 h-6 text-primary" />
      Account
    </Link>
  );
}
