"use client";
import { ShoppingCartIcon } from '@heroicons/react/24/solid';
import type { Tables } from '@/types/supabase';
import { useState } from 'react';
import { useCartContext } from '@/features/cart/CartContext';

interface Props {
  product: Tables['content_items'];
  className?: string;
}

export default function AddToCartButton({ product, className = '' }: Props) {
  const { addToCart, loading } = useCartContext();
  const [quantity, setQuantity] = useState(1);
  return (
    <button
      className={`flex items-center gap-1 px-3 py-1.5 rounded-lg bg-primary text-primary-foreground font-semibold shadow-card hover:bg-secondary hover:scale-105 transition-all duration-150 ${className}`}
      onClick={e => {
        e.preventDefault();
        addToCart(product, quantity);
      }}
      disabled={loading}
      aria-label="Add to cart"
      type="button"
    >
      <ShoppingCartIcon className="w-5 h-5" />
      Add
    </button>
  );
}
