"use client";
import Link from 'next/link';
import Image from 'next/image';
import type { Tables } from '@/types/supabase';
import AddToCartButton from './AddToCartButton';

interface Props {
  product: Tables['content_items'];
}

export default function ProductCard({ product }: Props) {
  return (
    <div className="rounded-2xl bg-background shadow-card hover:shadow-lg transition-shadow duration-150 p-4 flex flex-col group">
      <Link href={`/products/${product.id}`} className="block">
        <div className="relative aspect-square rounded-xl overflow-hidden mb-4">
          <Image
            src={product.image_url}
            alt={product.title}
            width={400}
            height={400}
            className="object-cover h-full w-full group-hover:scale-105 transition-transform duration-200"
          />
        </div>
        <h3 className="font-heading text-lg font-semibold mb-1 truncate">
          {product.title}
        </h3>
        <p className="text-muted-foreground text-sm mb-2 line-clamp-2 min-h-[40px]">
          {product.description}
        </p>
        <div className="flex items-center justify-between mt-auto py-2">
          <span className="font-bold text-primary text-lg">${product.price.toFixed(2)}</span>
          <AddToCartButton product={product} />
        </div>
      </Link>
    </div>
  );
}
