"use client";
import { useState } from 'react';
import type { Tables } from '@/types/supabase';
import { useCartContext } from '@/features/cart/CartContext';

interface Props {
  product: Tables['content_items'];
}

export default function ProductDetailActions({ product }: Props) {
  const [quantity, setQuantity] = useState(1);
  const { addToCart, loading } = useCartContext();
  return (
    <div className="flex gap-4 mt-2 items-center">
      <div className="flex items-center gap-1">
        <label htmlFor="quantity" className="sr-only">Quantity</label>
        <input
          id="quantity"
          type="number"
          min={1}
          value={quantity}
          onChange={e => setQuantity(Math.max(1, Number(e.target.value)))}
          className="w-16 px-2 py-1 rounded border border-muted-foreground bg-muted focus:ring-2 focus:ring-primary text-center font-medium"
        />
      </div>
      <button
        className="flex items-center gap-2 px-6 py-2 rounded-lg bg-primary text-primary-foreground font-semibold shadow-card hover:bg-secondary hover:scale-105 transition-all duration-150"
        onClick={() => addToCart(product, quantity)}
        disabled={loading}
        type="button"
      >
        Add to Cart
      </button>
    </div>
  );
}
