import dynamic from 'next/dynamic';
import type { Tables } from '@/types/supabase';

const ProductCard = dynamic(() => import('./ProductCard'));

interface Props {
  products: Tables['content_items'][];
}

export default function ProductGrid({ products }: Props) {
  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
      {products.map(product => (
        <ProductCard key={product.id} product={product} />
      ))}
    </div>
  );
}
