import clsx from 'clsx';

interface Props {
  type?: 'grid' | 'card';
}

export default function LoadingSkeleton({ type = 'grid' }: Props) {
  if (type === 'card') {
    return (
      <div className="animate-pulse rounded-2xl bg-muted shadow-card p-4 flex flex-col gap-4">
        <div className="h-48 w-full bg-gray-200 rounded-xl" />
        <div className="h-6 w-3/4 bg-gray-200 rounded" />
        <div className="h-4 w-1/2 bg-gray-200 rounded" />
        <div className="h-4 w-1/4 bg-gray-200 rounded" />
      </div>
    );
  }
  // grid
  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
      {Array.from({ length: 8 }).map((_, idx) => (
        <div key={idx} className="animate-pulse rounded-2xl bg-muted shadow-card p-4 flex flex-col gap-4">
          <div className="h-48 w-full bg-gray-200 rounded-xl" />
          <div className="h-6 w-3/4 bg-gray-200 rounded" />
          <div className="h-4 w-1/2 bg-gray-200 rounded" />
          <div className="h-4 w-1/4 bg-gray-200 rounded" />
        </div>
      ))}
    </div>
  );
}
