"use client";
import { createContext, useContext, ReactNode } from "react";
import { useCart } from "./useCart";
import type { CartItem } from "@/types/cart";
import type { Tables } from "@/types/supabase";

// Define the context type
interface CartContextType {
  cart: CartItem[];
  loading: boolean;
  error: string | null;
  addToCart: (product: Tables['content_items'], quantity?: number) => Promise<void>;
  updateQuantity: (cartId: string, quantity: number) => Promise<void>;
  removeFromCart: (cartId: string) => Promise<void>;
  clearCart: () => Promise<void>;
  fetchCart: () => Promise<void>;
  subtotal: number;
}

// Create the context with a default value
const CartContext = createContext<CartContextType | undefined>(undefined);

// Create a provider component
export function CartProvider({ children }: { children: ReactNode }) {
  const cartData = useCart();
  
  return (
    <CartContext.Provider value={cartData}>
      {children}
    </CartContext.Provider>
  );
}

// Create a hook to use the cart context
export function useCartContext() {
  const context = useContext(CartContext);
  if (context === undefined) {
    throw new Error("useCartContext must be used within a CartProvider");
  }
  return context;
} 