// This file is for Supabase types
export type Json = string | number | boolean | null | { [key: string]: Json } | Json[];

export type Tables = {
  content_items: {
    id: string;
    title: string;
    description: string;
    price: number;
    image_url: string;
    category: string;
    created_at: string;
    updated_at: string;
  };
  cart: {
    id: string;
    user_id: string;
    product_id: string;
    quantity: number;
    created_at: string;
  };
};

export type Database = {
  public: {
    Tables: Tables;
    Views: {};
    Functions: {};
  };
};
