# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._base_client import make_request_options
from ...types.market.kline import Kline

__all__ = ["KlineResource", "AsyncKlineResource"]


class KlineResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> KlineResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/SigmaEf5ect/sigma-sdk-python#accessing-raw-response-data-eg-headers
        """
        return KlineResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> KlineResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/SigmaEf5ect/sigma-sdk-python#with_streaming_response
        """
        return KlineResourceWithStreamingResponse(self)

    def retrieve(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Kline:
        """Get historical kline data"""
        return self._get(
            "/market/kline",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=Kline,
        )

    def get(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Kline:
        """Get historical kline data"""
        return self._get(
            "/market/kline",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=Kline,
        )


class AsyncKlineResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncKlineResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/SigmaEf5ect/sigma-sdk-python#accessing-raw-response-data-eg-headers
        """
        return AsyncKlineResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncKlineResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/SigmaEf5ect/sigma-sdk-python#with_streaming_response
        """
        return AsyncKlineResourceWithStreamingResponse(self)

    async def retrieve(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Kline:
        """Get historical kline data"""
        return await self._get(
            "/market/kline",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=Kline,
        )

    async def get(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Kline:
        """Get historical kline data"""
        return await self._get(
            "/market/kline",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=Kline,
        )


class KlineResourceWithRawResponse:
    def __init__(self, kline: KlineResource) -> None:
        self._kline = kline

        self.retrieve = to_raw_response_wrapper(
            kline.retrieve,
        )
        self.get = to_raw_response_wrapper(
            kline.get,
        )


class AsyncKlineResourceWithRawResponse:
    def __init__(self, kline: AsyncKlineResource) -> None:
        self._kline = kline

        self.retrieve = async_to_raw_response_wrapper(
            kline.retrieve,
        )
        self.get = async_to_raw_response_wrapper(
            kline.get,
        )


class KlineResourceWithStreamingResponse:
    def __init__(self, kline: KlineResource) -> None:
        self._kline = kline

        self.retrieve = to_streamed_response_wrapper(
            kline.retrieve,
        )
        self.get = to_streamed_response_wrapper(
            kline.get,
        )


class AsyncKlineResourceWithStreamingResponse:
    def __init__(self, kline: AsyncKlineResource) -> None:
        self._kline = kline

        self.retrieve = async_to_streamed_response_wrapper(
            kline.retrieve,
        )
        self.get = async_to_streamed_response_wrapper(
            kline.get,
        )
