
from __future__ import annotations

# Public constants/helpers
from .const import *  # noqa: F401,F403

# Core helpers (chỉ giữ TA & request)
from .core import (
    add_all_ta_features,
    send_request,
)

# Crypto (đọc S3)
from .utils import get_crypto

# Backward-compatibility: giữ get_hist của stocks nếu tồn tại (optional)
try:
    from .stocks import get_hist as get_stock_hist  # type: ignore
    get_hist = get_stock_hist  # alias mặc định
except Exception:
    # Không có module stocks trong gói này — bỏ qua
    pass

__all__ = [
    # helpers
    "send_request",
    # TA features
    "add_all_ta_features",
    # crypto
    "get_crypto",
]
