
"""
ĐÃ THAY THẾ: Module derivatives nay đã được thay bằng hàm `get_crypto` (đọc dữ liệu crypto từ S3).
Vui lòng chuyển sang: from .crypto import get_crypto
"""
from __future__ import annotations

from .utils import get_crypto as _get_crypto

__all__ = ["get_hist"]

def get_hist(symbol: str, frequency: str = "1D", *, days: int | None = None, **kwargs):
    """
    [Deprecated] Giả lập API cũ:
    - Bỏ qua tham số `frequency` của phái sinh; dùng `days` nếu truyền vào.
    - Gọi sang crypto.get_crypto(...).
    """
    if days is None:
        # Mặc định map frequency sang days đơn giản
        freq_map = {"1D": 365, "1H": 30, "5M": 7}
        days = freq_map.get(str(frequency).upper(), None)
    return _get_crypto(symbol, days=days, **kwargs)
