# Generated by Django 5.2.6 on 2025-09-30 01:40

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_crypto_fields.fields.encrypted_char_field
import django_revision.revision_field
import edc_consent.managers
import edc_consent.validators
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("meta_consent", "0032_alter_historicalsubjectconsent_device_created_and_more"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalSubjectConsentSpfq",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_reviewed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have reviewed the consent with the participant",
                    ),
                ),
                (
                    "study_questions",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have answered all questions the participant had about the study",
                    ),
                ),
                (
                    "assessment_score",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have asked the participant questions about this study and the participant has demonstrated understanding",
                    ),
                ),
                (
                    "consent_signature",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have verified that the participant has signed the consent form",
                    ),
                ),
                (
                    "consent_copy",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("Declined", "Yes, but subject declined copy"),
                        ],
                        help_text="If declined, return copy with the consent",
                        max_length=20,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes_or_declined],
                        verbose_name="I have provided the participant with a copy of their signed informed consent",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="Hold slug field values for quick search. Excludes encrypted fields",
                        max_length=250,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Subject identifier"
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        default="",
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="Ensure initials consist of letters only in upper case, no spaces.",
                                regex="^[A-Z]{2,3}$",
                            )
                        ],
                    ),
                ),
                (
                    "gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female")],
                        max_length=1,
                        verbose_name="Gender",
                    ),
                ),
                (
                    "consent_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name="Consent datetime",
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False, null=True)),
                (
                    "language",
                    models.CharField(
                        choices=[
                            ("sw", "Swahili"),
                            ("en-gb", "British English"),
                            ("en", "English"),
                            ("mas", "Maasai"),
                        ],
                        help_text="The language used for the consent process will also be used during data collection.",
                        max_length=25,
                        verbose_name="Language of consent",
                    ),
                ),
                (
                    "model_name",
                    models.CharField(
                        default="",
                        editable=False,
                        help_text="label_lower of this model class. Will be different if instance has been added/edited via a proxy model",
                        max_length=50,
                        verbose_name="model",
                    ),
                ),
                (
                    "version",
                    models.CharField(
                        default="1.0",
                        editable=False,
                        help_text="See 'consent definition' for consent versions by period.",
                        max_length=10,
                        verbose_name="Consent version",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Consent for SPFQ",
                "verbose_name_plural": "historical Subject Consents for SPFQ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="SubjectConsentSpfq",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_reviewed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have reviewed the consent with the participant",
                    ),
                ),
                (
                    "study_questions",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have answered all questions the participant had about the study",
                    ),
                ),
                (
                    "assessment_score",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have asked the participant questions about this study and the participant has demonstrated understanding",
                    ),
                ),
                (
                    "consent_signature",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If no, participant is not eligible.",
                        max_length=3,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes],
                        verbose_name="I have verified that the participant has signed the consent form",
                    ),
                ),
                (
                    "consent_copy",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("Declined", "Yes, but subject declined copy"),
                        ],
                        help_text="If declined, return copy with the consent",
                        max_length=20,
                        null=True,
                        validators=[edc_consent.validators.eligible_if_yes_or_declined],
                        verbose_name="I have provided the participant with a copy of their signed informed consent",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="Hold slug field values for quick search. Excludes encrypted fields",
                        max_length=250,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject identifier"
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        default="",
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="Ensure initials consist of letters only in upper case, no spaces.",
                                regex="^[A-Z]{2,3}$",
                            )
                        ],
                    ),
                ),
                (
                    "gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female")],
                        max_length=1,
                        verbose_name="Gender",
                    ),
                ),
                (
                    "consent_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name="Consent datetime",
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False, null=True)),
                (
                    "language",
                    models.CharField(
                        choices=[
                            ("sw", "Swahili"),
                            ("en-gb", "British English"),
                            ("en", "English"),
                            ("mas", "Maasai"),
                        ],
                        help_text="The language used for the consent process will also be used during data collection.",
                        max_length=25,
                        verbose_name="Language of consent",
                    ),
                ),
                (
                    "model_name",
                    models.CharField(
                        default="",
                        editable=False,
                        help_text="label_lower of this model class. Will be different if instance has been added/edited via a proxy model",
                        max_length=50,
                        verbose_name="model",
                    ),
                ),
                (
                    "version",
                    models.CharField(
                        default="1.0",
                        editable=False,
                        help_text="See 'consent definition' for consent versions by period.",
                        max_length=10,
                        verbose_name="Consent version",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Consent for SPFQ",
                "verbose_name_plural": "Subject Consents for SPFQ",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["modified", "created"],
                        name="meta_consen_modifie_561720_idx",
                    ),
                    models.Index(
                        fields=["user_modified", "user_created"],
                        name="meta_consen_user_mo_163676_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_consent.managers.ConsentObjectsManager()),
            ],
        ),
    ]
