# Generated by Django 5.1 on 2024-10-07 22:05

import _socket
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django.utils.timezone
import django_revision.revision_field
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_pharmacy", "0005_auto_20240911_0352"),
    ]

    operations = [
        migrations.CreateModel(
            name="LotNumber",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("lot_no", models.CharField(max_length=25, unique=True)),
                (
                    "allocation",
                    models.CharField(
                        choices=[("active", "Active"), ("placebo", "Placebo")], max_length=25
                    ),
                ),
                ("expiration_date", models.DateField()),
                ("qty", models.IntegerField(null=True)),
            ],
            options={
                "verbose_name": "Lot Number",
                "verbose_name_plural": "Lot Numbers",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["modified", "created"], name="meta_pharma_modifie_a98e60_idx"
                    ),
                    models.Index(
                        fields=["user_modified", "user_created"],
                        name="meta_pharma_user_mo_1be860_idx",
                    ),
                ],
            },
        ),
        migrations.CreateModel(
            name="Label",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("rx_label_reference", models.CharField(max_length=15, unique=True)),
                ("printed_datetime", models.DateTimeField(null=True)),
                ("printed", models.BooleanField(default=False)),
                ("scanned", models.BooleanField(default=False)),
                ("scanned_datetime", models.DateTimeField(null=True)),
                (
                    "rx",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="meta_pharmacy.rx"
                    ),
                ),
                (
                    "lot_no",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_pharmacy.lotnumber",
                    ),
                ),
            ],
            options={
                "verbose_name": "Label",
                "verbose_name_plural": "Labels",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["modified", "created"], name="meta_pharma_modifie_ebebcc_idx"
                    ),
                    models.Index(
                        fields=["user_modified", "user_created"],
                        name="meta_pharma_user_mo_cd7246_idx",
                    ),
                ],
            },
        ),
    ]
