# Generated by Django 3.2.6 on 2021-09-10 16:11

from django.db import migrations
from django.db.migrations import RunPython


def convert_violation_type_to_fk(apps, schema_editor):
    model_cls = apps.get_model("meta_prn", "protocoldeviationviolation")
    list_model_cls = apps.get_model("edc_protocol_incident", "protocolviolations")
    for obj in model_cls.objects.all():
        violation_type = list_model_cls.objects.get(name=obj.violation_type)
        obj.violation = violation_type
        obj.violation_other = obj.violation_type_other
        obj.save_base(update_fields=["violation", "violation_other"])


class Migration(migrations.Migration):
    dependencies = [
        ("meta_prn", "0011_auto_20210910_1911"),
    ]

    operations = [RunPython(convert_violation_type_to_fk)]
