# Generated by Django 5.0.8 on 2024-08-23 13:59

import _socket
import django.db.models.deletion
import django.db.models.manager
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django.utils.timezone
import django_revision.revision_field
import edc_model.validators.date
import edc_sites.managers
import edc_utils.date
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_reports", "0034_auto_20240823_1642"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalMissingOgttNote",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(db_index=True, max_length=50)),
                ("report_model", models.CharField(max_length=150)),
                ("report_datetime", models.DateTimeField(default=edc_utils.date.get_utcnow)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date/time oral glucose solution given",
                    ),
                ),
                (
                    "ogtt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose measure 2hrs <u>after</u> oral glucose solution given",
                    ),
                ),
                (
                    "ogtt_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "ogtt_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Units (Blood glucose 2hrs after...)",
                    ),
                ),
                (
                    "ogtt_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(2 hours after glucose solution given)",
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date/time blood glucose measured 2hrs <u>after</u> oral glucose solution given",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("done", "Done"),
                            ("PENDING", "Data is pending"),
                            ("not_available", "Data not available"),
                        ],
                        default="done",
                        max_length=25,
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Screening: Missing OGTT Note",
                "verbose_name_plural": "historical Screening: Missing OGTT Notes",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="MissingOgttNote",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("report_model", models.CharField(max_length=150)),
                ("report_datetime", models.DateTimeField(default=edc_utils.date.get_utcnow)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date/time oral glucose solution given",
                    ),
                ),
                (
                    "ogtt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose measure 2hrs <u>after</u> oral glucose solution given",
                    ),
                ),
                (
                    "ogtt_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "ogtt_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Units (Blood glucose 2hrs after...)",
                    ),
                ),
                (
                    "ogtt_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(2 hours after glucose solution given)",
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date/time blood glucose measured 2hrs <u>after</u> oral glucose solution given",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("done", "Done"),
                            ("PENDING", "Data is pending"),
                            ("not_available", "Data not available"),
                        ],
                        default="done",
                        max_length=25,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Screening: Missing OGTT Note",
                "verbose_name_plural": "Screening: Missing OGTT Notes",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["modified", "created"], name="meta_report_modifie_4a4894_idx"
                    ),
                    models.Index(
                        fields=["user_modified", "user_created"],
                        name="meta_report_user_mo_5b8129_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
    ]
