# Generated by Django 5.0.8 on 2024-08-24 01:12

import django_db_views.migration_functions
import django_db_views.operations
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("meta_reports", "0039_onstudymissingvalues"),
    ]

    operations = [
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, now() as `created`, 'meta_reports.glucose_summary_view' as `report_model` from (SELECT v.subject_identifier, fbg_value, fbg_datetime, NULL AS `ogtt_value`, NULL AS `ogtt_datetime`, CASE WHEN fasting = 'fasting' THEN 'Yes' WHEN fasting = 'non_fasting' THEN 'No' ELSE fasting END AS `fasted`, fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime FROM meta_subject_glucosefbg AS fbg LEFT JOIN meta_subject_subjectvisit AS v ON v.id = fbg.subject_visit_id LEFT JOIN meta_prn_endofstudy AS eos ON v.subject_identifier = eos.subject_identifier UNION SELECT v.subject_identifier, fbg_value, fbg_datetime, ogtt_value, ogtt_datetime, CASE WHEN fasting = 'fasting' THEN 'Yes' WHEN fasting = 'non_fasting' THEN 'No' ELSE fasting END AS `fasted`, fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime FROM meta_subject_glucose AS fbg LEFT JOIN meta_subject_subjectvisit AS v ON v.id = fbg.subject_visit_id LEFT JOIN meta_prn_endofstudy AS eos ON v.subject_identifier = eos.subject_identifier) as A ORDER BY subject_identifier, site_id",
                "glucose_summary_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                '# noqa\nselect *, uuid() as id, now() as created, \'meta_reports.glucose_summary_view\' as report_model\nfrom (\n    select v.subject_identifier, fbg_value, fbg_datetime, null as \'ogtt_value\', null as \'ogtt_datetime\',\n    case when fasting="fasting" then "Yes" when fasting="non_fasting" then "No" else fasting end as \'fasted\',\n    fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime\n    from meta_subject_glucosefbg as fbg\n    left join meta_subject_subjectvisit as v on v.id=fbg.subject_visit_id\n    left join meta_prn_endofstudy as eos on v.subject_identifier=eos.subject_identifier\n    UNION\n    select v.subject_identifier, fbg_value, fbg_datetime, ogtt_value, ogtt_datetime,\n    case when fasting="fasting" then "Yes" when fasting="non_fasting" then "No" else fasting end as \'fasted\',\n    fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime\n    from meta_subject_glucose as fbg\n    left join meta_subject_subjectvisit as v on v.id=fbg.subject_visit_id\n    left join meta_prn_endofstudy as eos on v.subject_identifier=eos.subject_identifier\n) as A\norder by subject_identifier, fbg_datetime',
                "glucose_summary_view",
                engine="django.db.backends.mysql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, get_random_uuid() as id, now() as created, 'meta_reports.glucose_summary_view' as report_model from (SELECT v.subject_identifier, fbg_value, fbg_datetime, NULL AS \"ogtt_value\", NULL AS \"ogtt_datetime\", CASE WHEN fasting = 'fasting' THEN 'Yes' WHEN fasting = 'non_fasting' THEN 'No' ELSE fasting END AS \"fasted\", fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime FROM meta_subject_glucosefbg AS fbg LEFT JOIN meta_subject_subjectvisit AS v ON v.id = fbg.subject_visit_id LEFT JOIN meta_prn_endofstudy AS eos ON v.subject_identifier = eos.subject_identifier UNION SELECT v.subject_identifier, fbg_value, fbg_datetime, ogtt_value, ogtt_datetime, CASE WHEN fasting = 'fasting' THEN 'Yes' WHEN fasting = 'non_fasting' THEN 'No' ELSE fasting END AS \"fasted\", fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime FROM meta_subject_glucose AS fbg LEFT JOIN meta_subject_subjectvisit AS v ON v.id = fbg.subject_visit_id LEFT JOIN meta_prn_endofstudy AS eos ON v.subject_identifier = eos.subject_identifier) as A ORDER BY subject_identifier, site_id",
                "glucose_summary_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                '# noqa\nselect *, get_random_uuid() as id, now() as created, \'meta_reports.glucose_summary_view\' as report_model\nfrom (\n    select v.subject_identifier, fbg_value, fbg_datetime, null as ogtt_value, null as ogtt_datetime,\n    case when fasting="fasting" then "Yes" when fasting="non_fasting" then "No" else fasting end as fasted,\n    fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime\n    from meta_subject_glucosefbg as fbg\n    left join meta_subject_subjectvisit as v on v.id=fbg.subject_visit_id\n    left join meta_prn_endofstudy as eos on v.subject_identifier=eos.subject_identifier\n    UNION\n    select v.subject_identifier, fbg_value, fbg_datetime, ogtt_value, ogtt_datetime,\n    case when fasting="fasting" then "Yes" when fasting="non_fasting" then "No" else fasting end as fasted,\n    fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime\n    from meta_subject_glucose as fbg\n    left join meta_subject_subjectvisit as v on v.id=fbg.subject_visit_id\n    left join meta_prn_endofstudy as eos on v.subject_identifier=eos.subject_identifier\n) as A\norder by subject_identifier, fbg_datetime',
                "glucose_summary_view",
                engine="django.db.backends.postgresql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, datetime() as created, 'meta_reports.glucose_summary_view' as report_model from (SELECT v.subject_identifier, fbg_value, fbg_datetime, NULL AS \"ogtt_value\", NULL AS \"ogtt_datetime\", CASE WHEN fasting = 'fasting' THEN 'Yes' WHEN fasting = 'non_fasting' THEN 'No' ELSE fasting END AS \"fasted\", fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime FROM meta_subject_glucosefbg AS fbg LEFT JOIN meta_subject_subjectvisit AS v ON v.id = fbg.subject_visit_id LEFT JOIN meta_prn_endofstudy AS eos ON v.subject_identifier = eos.subject_identifier UNION SELECT v.subject_identifier, fbg_value, fbg_datetime, ogtt_value, ogtt_datetime, CASE WHEN fasting = 'fasting' THEN 'Yes' WHEN fasting = 'non_fasting' THEN 'No' ELSE fasting END AS \"fasted\", fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime FROM meta_subject_glucose AS fbg LEFT JOIN meta_subject_subjectvisit AS v ON v.id = fbg.subject_visit_id LEFT JOIN meta_prn_endofstudy AS eos ON v.subject_identifier = eos.subject_identifier) as A ORDER BY subject_identifier, site_id",
                "glucose_summary_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                '# noqa\nSELECT *, lower(\n    hex(randomblob(4)) || \'-\' || hex(randomblob(2)) || \'-\' || \'4\' ||\n    substr(hex( randomblob(2)), 2) || \'-\' ||\n    substr(\'AB89\', 1 + (abs(random()) % 4) , 1)  ||\n    substr(hex(randomblob(2)), 2) || \'-\' ||\n    hex(randomblob(6))\n  ) as id, datetime() as `created`, \'meta_reports.glucose_summary_view\' as report_model\nfrom (\n    select v.subject_identifier, fbg_value, fbg_datetime, null as ogtt_value, null as ogtt_datetime,\n    case when fasting="fasting" then "Yes" when fasting="non_fasting" then "No" else fasting end as fasted,\n    fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime\n    from meta_subject_glucosefbg as fbg\n    left join meta_subject_subjectvisit as v on v.id=fbg.subject_visit_id\n    left join meta_prn_endofstudy as eos on v.subject_identifier=eos.subject_identifier\n    UNION\n    select v.subject_identifier, fbg_value, fbg_datetime, ogtt_value, ogtt_datetime,\n    case when fasting="fasting" then "Yes" when fasting="non_fasting" then "No" else fasting end as fasted,\n    fbg.site_id, v.visit_code, v.visit_code_sequence, v.appointment_id, eos.offstudy_datetime\n    from meta_subject_glucose as fbg\n    left join meta_subject_subjectvisit as v on v.id=fbg.subject_visit_id\n    left join meta_prn_endofstudy as eos on v.subject_identifier=eos.subject_identifier    \n    ) as A\norder by subject_identifier, fbg_datetime',
                "glucose_summary_view",
                engine="django.db.backends.sqlite3",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, now() as `created`, 'meta_reports.missing_screening_ogtt_view' as `report_model` from (SELECT screening_identifier, site_id, report_datetime AS `screening_datetime`, fbg_datetime, converted_fbg_value AS `fbg_value`, converted_ogtt_value AS `ogtt_value`, fbg2_value, ogtt2_value, repeat_glucose_performed AS `repeated`, p3_ltfu, fbg2_datetime, ogtt2_datetime, consented, screening_identifier AS `subject_identifier`, id AS `original_id` FROM meta_screening_subjectscreening WHERE NOT converted_fbg_value IS NULL AND converted_ogtt_value IS NULL AND unsuitable_agreed <> 'Yes') as A ORDER BY subject_identifier, site_id",
                "missing_screening_ogtt_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    select *, uuid() as id, now() as created,\n    'meta_reports.missing_screening_ogtt_view' as report_model\n      from (\n        select screening_identifier, site_id, report_datetime as 'screening_datetime', fbg_datetime,\n        converted_fbg_value as fbg_value,  converted_ogtt_value as ogtt_value, repeat_glucose_performed as repeated,\n        p3_ltfu, fbg2_value, ogtt2_value, fbg2_datetime, ogtt2_datetime, consented,\n        screening_identifier as subject_identifier, id as original_id\n        from meta_screening_subjectscreening\n        where converted_fbg_value is not null and converted_ogtt_value is null and unsuitable_agreed != \"Yes\"\n    ) as A\n    order by screening_identifier",
                "missing_screening_ogtt_view",
                engine="django.db.backends.mysql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'select *, get_random_uuid() as id, now() as created, \'meta_reports.missing_screening_ogtt_view\' as report_model from (SELECT screening_identifier, site_id, report_datetime AS "screening_datetime", fbg_datetime, converted_fbg_value AS "fbg_value", converted_ogtt_value AS "ogtt_value", fbg2_value, ogtt2_value, repeat_glucose_performed AS "repeated", p3_ltfu, fbg2_datetime, ogtt2_datetime, consented, screening_identifier AS "subject_identifier", id AS "original_id" FROM meta_screening_subjectscreening WHERE NOT converted_fbg_value IS NULL AND converted_ogtt_value IS NULL AND unsuitable_agreed <> \'Yes\') as A ORDER BY subject_identifier, site_id',
                "missing_screening_ogtt_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    select *, get_random_uuid() as id, now() as created,\n    'meta_reports.missing_screening_ogtt_view' as report_model\n      from (\n        select screening_identifier, site_id, report_datetime as 'screening_datetime', fbg_datetime,\n        converted_fbg_value as fbg_value,  converted_ogtt_value as ogtt_value, repeat_glucose_performed as repeated,\n        p3_ltfu, fbg2_value, ogtt2_value, fbg2_datetime, ogtt2_datetime, consented,\n        screening_identifier as subject_identifier, id as original_id\n        from meta_screening_subjectscreening\n        where converted_fbg_value is not null and converted_ogtt_value is null and unsuitable_agreed != \"Yes\"\n    ) as A\n    order by screening_identifier",
                "missing_screening_ogtt_view",
                engine="django.db.backends.postgresql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'select *, uuid() as id, datetime() as created, \'meta_reports.missing_screening_ogtt_view\' as report_model from (SELECT screening_identifier, site_id, report_datetime AS "screening_datetime", fbg_datetime, converted_fbg_value AS "fbg_value", converted_ogtt_value AS "ogtt_value", fbg2_value, ogtt2_value, repeat_glucose_performed AS "repeated", p3_ltfu, fbg2_datetime, ogtt2_datetime, consented, screening_identifier AS "subject_identifier", id AS "original_id" FROM meta_screening_subjectscreening WHERE NOT converted_fbg_value IS NULL AND converted_ogtt_value IS NULL AND unsuitable_agreed <> \'Yes\') as A ORDER BY subject_identifier, site_id',
                "missing_screening_ogtt_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\nSELECT *, lower(\n    hex(randomblob(4)) || '-' || hex(randomblob(2)) || '-' || '4' ||\n    substr(hex( randomblob(2)), 2) || '-' ||\n    substr('AB89', 1 + (abs(random()) % 4) , 1)  ||\n    substr(hex(randomblob(2)), 2) || '-' ||\n    hex(randomblob(6))\n  ) as id, datetime() as `created`,\n    'meta_reports.missing_screening_ogtt_view' as report_model\n      from (\n        select screening_identifier, site_id, report_datetime as 'screening_datetime', fbg_datetime,\n        converted_fbg_value as fbg_value,  converted_ogtt_value as ogtt_value, fbg2_value, ogtt2_value,\n        repeat_glucose_performed as repeated, p3_ltfu, fbg2_datetime, ogtt2_datetime, consented,\n        screening_identifier as subject_identifier, id as original_id\n        from meta_screening_subjectscreening\n        where converted_fbg_value is not null and converted_ogtt_value is null and unsuitable_agreed != \"Yes\"\n    ) as A\n    order by screening_identifier",
                "missing_screening_ogtt_view",
                engine="django.db.backends.sqlite3",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, now() as `created`, 'onstudy_missing_values_view' as `report_model` from (SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No HIV Diagnosis date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.hiv_diagnosis_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No VL value' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.viral_load IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No VL date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.viral_load_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No CD4 value' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.cd4 IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No CD4 date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.cd4_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No current ARV start date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.current_arv_regimen_start_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No current ARV start date but previous ARV is YES' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.has_previous_arv_regimen = 'YES' AND crf.current_arv_regimen_start_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'Other current ARV regimen missing' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id LEFT JOIN meta_lists_arvregimens AS arvregimen ON crf.current_arv_regimen_id = arvregimen.id WHERE crf.other_current_arv_regimen IS NULL AND arvregimen.name = 'OTHER' GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified) as A ORDER BY subject_identifier, site_id",
                "onstudy_missing_values_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "", "onstudy_missing_values_view", engine="django.db.backends.mysql"
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, get_random_uuid() as id, now() as created, 'onstudy_missing_values_view' as report_model from (SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No HIV Diagnosis date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.hiv_diagnosis_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No VL value' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.viral_load IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No VL date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.viral_load_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No CD4 value' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.cd4 IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No CD4 date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.cd4_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No current ARV start date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.current_arv_regimen_start_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No current ARV start date but previous ARV is YES' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.has_previous_arv_regimen = 'YES' AND crf.current_arv_regimen_start_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'Other current ARV regimen missing' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id LEFT JOIN meta_lists_arvregimens AS arvregimen ON crf.current_arv_regimen_id = arvregimen.id WHERE crf.other_current_arv_regimen IS NULL AND arvregimen.name = 'OTHER' GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified) as A ORDER BY subject_identifier, site_id",
                "onstudy_missing_values_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "", "onstudy_missing_values_view", engine="django.db.backends.postgresql"
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, datetime() as created, 'onstudy_missing_values_view' as report_model from (SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No HIV Diagnosis date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.hiv_diagnosis_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No VL value' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.viral_load IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No VL date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.viral_load_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No CD4 value' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.cd4 IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No CD4 date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.cd4_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No current ARV start date' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.current_arv_regimen_start_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'No current ARV start date but previous ARV is YES' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id WHERE crf.has_previous_arv_regimen = 'YES' AND crf.current_arv_regimen_start_date IS NULL GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified UNION SELECT v.subject_identifier, crf.id AS original_id, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified, 'meta_subject.patienthistory' AS label_lower, 'Other current ARV regimen missing' AS label, COUNT(*) AS records FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON v.id = crf.subject_visit_id LEFT JOIN meta_lists_arvregimens AS arvregimen ON crf.current_arv_regimen_id = arvregimen.id WHERE crf.other_current_arv_regimen IS NULL AND arvregimen.name = 'OTHER' GROUP BY v.subject_identifier, crf.subject_visit_id, crf.report_datetime, crf.site_id, v.visit_code, v.visit_code_sequence, v.schedule_name, crf.modified) as A ORDER BY subject_identifier, site_id",
                "onstudy_missing_values_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "", "onstudy_missing_values_view", engine="django.db.backends.sqlite3"
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, now() as `created`, 'meta_reports.patienthistorymissingbaselinecd4' as `report_model` from (SELECT subject_identifier, v.visit_code, v.visit_code_sequence, cd4, cd4_date, crf.site_id, crf.user_created, crf.user_modified, crf.modified FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON crf.subject_visit_id = v.id WHERE cd4 IS NULL OR cd4_date IS NULL) as A ORDER BY subject_identifier, site_id",
                "patient_history_missing_baseline_cd4_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "select *, uuid() as id, now() as created, \n    'meta_reports.patienthistorymissingbaselinecd4' as report_model \n      from (\n        select subject_identifier, v.visit_code, v.visit_code_sequence,cd4,\n          cd4_date, crf.site_id, crf.user_created, crf.user_modified,\n          crf.modified\n        from meta_subject_patienthistory as crf\n        left join meta_subject_subjectvisit as v on crf.subject_visit_id=v.id\n        where cd4 is null or cd4_date is null\n    ) as A\n    order by subject_identifier",
                "patient_history_missing_baseline_cd4_view",
                engine="django.db.backends.mysql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, get_random_uuid() as id, now() as created, 'meta_reports.patienthistorymissingbaselinecd4' as report_model from (SELECT subject_identifier, v.visit_code, v.visit_code_sequence, cd4, cd4_date, crf.site_id, crf.user_created, crf.user_modified, crf.modified FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON crf.subject_visit_id = v.id WHERE cd4 IS NULL OR cd4_date IS NULL) as A ORDER BY subject_identifier, site_id",
                "patient_history_missing_baseline_cd4_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "select *, get_random_uuid() as id, now() as created, \n    'meta_reports.patienthistorymissingbaselinecd4' as report_model \n      from (\n        select subject_identifier, v.visit_code, v.visit_code_sequence,cd4,\n          cd4_date, crf.site_id, crf.user_created, crf.user_modified,\n          crf.modified\n        from meta_subject_patienthistory as crf\n        left join meta_subject_subjectvisit as v on crf.subject_visit_id=v.id\n        where cd4 is null or cd4_date is null\n    ) as A\n    order by subject_identifier",
                "patient_history_missing_baseline_cd4_view",
                engine="django.db.backends.postgresql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, datetime() as created, 'meta_reports.patienthistorymissingbaselinecd4' as report_model from (SELECT subject_identifier, v.visit_code, v.visit_code_sequence, cd4, cd4_date, crf.site_id, crf.user_created, crf.user_modified, crf.modified FROM meta_subject_patienthistory AS crf LEFT JOIN meta_subject_subjectvisit AS v ON crf.subject_visit_id = v.id WHERE cd4 IS NULL OR cd4_date IS NULL) as A ORDER BY subject_identifier, site_id",
                "patient_history_missing_baseline_cd4_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "SELECT *, lower(\n    hex(randomblob(4)) || '-' || hex(randomblob(2)) || '-' || '4' ||\n    substr(hex( randomblob(2)), 2) || '-' ||\n    substr('AB89', 1 + (abs(random()) % 4) , 1)  ||\n    substr(hex(randomblob(2)), 2) || '-' ||\n    hex(randomblob(6))\n  ) as id, datetime() as `created`, 'meta_reports.patienthistorymissingbaselinecd4' as report_model \n      from (\n        select subject_identifier, v.visit_code, v.visit_code_sequence,cd4,\n          cd4_date, crf.site_id, crf.user_created, crf.user_modified,\n          crf.modified\n        from meta_subject_patienthistory as crf\n        left join meta_subject_subjectvisit as v on crf.subject_visit_id=v.id\n        where cd4 is null or cd4_date is null\n    ) as A\n    order by subject_identifier",
                "patient_history_missing_baseline_cd4_view",
                engine="django.db.backends.sqlite3",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, now() as `created`, 'meta_reports.unattendedthreeinrow' as `report_model` from (SELECT subject_identifier, site_id, appt_datetime, `first_value`, `second_value`, `third_value`, DATEDIFF(`third_date`, `first_date`) AS `interval_days`, DATEDIFF(NOW(), `first_date`) AS `from_now_days` FROM (SELECT subject_identifier, site_id, appt_datetime, FIRST_VALUE(visit_code) OVER w AS `first_value`, NTH_VALUE(visit_code, 2) OVER w AS `second_value`, NTH_VALUE(visit_code, 3) OVER w AS `third_value`, FIRST_VALUE(appt_datetime) OVER w AS `first_date`, NTH_VALUE(appt_datetime, 3) OVER w AS `third_date` FROM edc_appointment_appointment WHERE visit_code_sequence = 0 AND appt_status = 'New' AND appt_datetime <= NOW() WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT `second_value` IS NULL AND NOT `third_value` IS NULL) as A ORDER BY subject_identifier, site_id",
                "unattended_three_in_row_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    select *, uuid() as id, now() as created, 'meta_reports.unattendedthreeinrow' as `report_model` from (\n        select subject_identifier, site_id, appt_datetime, `first_value`, `second_value`, `third_value`,\n            datediff(third_date, first_date) as `interval_days`,\n            datediff(now(), first_date) as `from_now_days`\n        from (\n            select subject_identifier, site_id, appt_datetime,\n            FIRST_VALUE(visit_code) OVER w as `first_value`,\n            NTH_VALUE(visit_code, 2) OVER w as `second_value`,\n            NTH_VALUE(visit_code, 3) OVER w as `third_value`,\n            FIRST_VALUE(appt_datetime) OVER w as `first_date`,\n            NTH_VALUE(appt_datetime, 3) OVER w as `third_date`\n            from edc_appointment_appointment where visit_code_sequence=0 and appt_status='New'\n            and appt_datetime <= now()\n            WINDOW w as (PARTITION BY subject_identifier order by appt_datetime ROWS UNBOUNDED PRECEDING)\n        ) as A\n    where `second_value` is not null and `third_value` is not null\n    ) as B\n    order by site_id, from_now_days desc",
                "unattended_three_in_row_view",
                engine="django.db.backends.mysql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'select *, get_random_uuid() as id, now() as created, \'meta_reports.unattendedthreeinrow\' as report_model from (SELECT subject_identifier, site_id, appt_datetime, "first_value", "second_value", "third_value", CAST(AGE(CAST("third_date" AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT) AS "interval_days", CAST(AGE(CAST(NOW() AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT) AS "from_now_days" FROM (SELECT subject_identifier, site_id, appt_datetime, FIRST_VALUE(visit_code) OVER w AS "first_value", NTH_VALUE(visit_code, 2) OVER w AS "second_value", NTH_VALUE(visit_code, 3) OVER w AS "third_value", FIRST_VALUE(appt_datetime) OVER w AS "first_date", NTH_VALUE(appt_datetime, 3) OVER w AS "third_date" FROM edc_appointment_appointment WHERE visit_code_sequence = 0 AND appt_status = \'New\' AND appt_datetime <= NOW() WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime NULLS FIRST ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT "second_value" IS NULL AND NOT "third_value" IS NULL) as A ORDER BY subject_identifier, site_id',
                "unattended_three_in_row_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    select *, gen_random_uuid() as id, now() as created,\n    'meta_reports.unattendedthreeinrow' as report_model\n    from (\n    select subject_identifier, site_id, appt_datetime, first_value, second_value, third_value,\n    EXTRACT(DAY FROM third_date - first_date) as interval_days,\n    EXTRACT(DAY FROM now() - first_date) as from_now_days\n    from (\n    select subject_identifier,site_id,appt_datetime,\n    FIRST_VALUE(visit_code) OVER w as first_value,\n    NTH_VALUE(visit_code, 2) OVER w as second_value,\n    NTH_VALUE(visit_code, 3) OVER w as third_value,\n    FIRST_VALUE(appt_datetime) OVER w as first_date,\n    NTH_VALUE(appt_datetime, 3) OVER w as third_date\n    from edc_appointment_appointment where visit_code_sequence=0 and appt_status='New'\n    and appt_datetime <= now()\n    WINDOW w as (PARTITION BY subject_identifier order by appt_datetime ROWS UNBOUNDED PRECEDING)\n    ) as A\n    where second_value is not null and third_value is not null\n    ) as B\n    order by site_id, from_now_days desc",
                "unattended_three_in_row_view",
                engine="django.db.backends.postgresql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'select *, uuid() as id, datetime() as created, \'meta_reports.unattendedthreeinrow\' as report_model from (SELECT subject_identifier, site_id, appt_datetime, "first_value", "second_value", "third_value", CAST((JULIANDAY("third_date") - JULIANDAY("first_date")) AS INTEGER) AS "interval_days", CAST((JULIANDAY(NOW()) - JULIANDAY("first_date")) AS INTEGER) AS "from_now_days" FROM (SELECT subject_identifier, site_id, appt_datetime, FIRST_VALUE(visit_code) OVER w AS "first_value", NTH_VALUE(visit_code, 2) OVER w AS "second_value", NTH_VALUE(visit_code, 3) OVER w AS "third_value", FIRST_VALUE(appt_datetime) OVER w AS "first_date", NTH_VALUE(appt_datetime, 3) OVER w AS "third_date" FROM edc_appointment_appointment WHERE visit_code_sequence = 0 AND appt_status = \'New\' AND appt_datetime <= NOW() WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT "second_value" IS NULL AND NOT "third_value" IS NULL) as A ORDER BY subject_identifier, site_id',
                "unattended_three_in_row_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\nSELECT *, lower(\n    hex(randomblob(4)) || '-' || hex(randomblob(2)) || '-' || '4' ||\n    substr(hex( randomblob(2)), 2) || '-' ||\n    substr('AB89', 1 + (abs(random()) % 4) , 1)  ||\n    substr(hex(randomblob(2)), 2) || '-' ||\n    hex(randomblob(6))\n  ) as id, datetime() as created,'meta_reports.unattendedthreeinrow' as report_model from (\n        select subject_identifier, site_id, appt_datetime, first_value, second_value, third_value,\n            CAST(JulianDay(third_date) - JulianDay(first_date) AS INTEGER) as interval_days,\n            CAST(JulianDay(datetime()) - JulianDay(first_date) AS INTEGER) as from_now_days\n        from (\n            select subject_identifier, site_id, appt_datetime,\n            FIRST_VALUE(visit_code) OVER w as first_value,\n            NTH_VALUE(visit_code, 2) OVER w as second_value,\n            NTH_VALUE(visit_code, 3) OVER w as third_value,\n            FIRST_VALUE(appt_datetime) OVER w as first_date,\n            NTH_VALUE(appt_datetime, 3) OVER w as third_date\n            from edc_appointment_appointment where visit_code_sequence=0 and appt_status='New'\n            and appt_datetime <= datetime()\n            WINDOW w as (PARTITION BY subject_identifier order by appt_datetime ROWS UNBOUNDED PRECEDING)\n        ) as A\n    where second_value is not null and third_value is not null\n    ) as B\n    order by site_id, from_now_days desc",
                "unattended_three_in_row_view",
                engine="django.db.backends.sqlite3",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "with appointments as (select subject_identifier, site_id, visit_code, visit_code_sequence,\nappt_datetime, case when appt_timing=\"missed\" then \"New\" else appt_status end as `appt_status`,\ncase when appt_timing=\"missed\" then 1 else 0 end as `missed`\nfrom edc_appointment_appointment\nwhere visit_code_sequence=0 and appt_datetime<=now()\norder by subject_identifier, appt_datetime) select *, uuid() as id, now() as `created`, 'meta_reports.unattendedthreeinrow2' as `report_model` from (SELECT DISTINCT subject_identifier, site_id, `first_value`, `second_value`, `third_value`, DATEDIFF(`third_date`, `first_date`) AS interval_days, DATEDIFF(NOW(), `first_date`) AS from_now_days, `first_status`, `second_status`, `third_status`, SUM(missed) AS missed_count FROM (SELECT subject_identifier, site_id, appt_datetime, `missed`, FIRST_VALUE(appt_status) OVER w AS `third_status`, NTH_VALUE(appt_status, 2) OVER w AS `second_status`, NTH_VALUE(appt_status, 3) OVER w AS `first_status`, FIRST_VALUE(visit_code) OVER w AS `third_value`, NTH_VALUE(visit_code, 2) OVER w AS `second_value`, NTH_VALUE(visit_code, 3) OVER w AS `first_value`, FIRST_VALUE(appt_datetime) OVER w AS `third_date`, NTH_VALUE(appt_datetime, 2) OVER w AS `second_date`, NTH_VALUE(appt_datetime, 3) OVER w AS `first_date` FROM appointments WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT `second_value` IS NULL AND NOT `third_value` IS NULL AND `first_status` = 'New' AND `second_status` = 'New' AND `third_status` = 'New' GROUP BY subject_identifier, site_id, `first_value`, `second_value`, `third_value`, DATEDIFF(`third_date`, `first_date`), DATEDIFF(NOW(), `first_date`), `first_status`, `second_status`, `third_status` ORDER BY subject_identifier, site_id) as A ORDER BY subject_identifier, site_id",
                "unattended_three_in_row2_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    with appointments as (\n        select subject_identifier, site_id, visit_code, visit_code_sequence, appt_datetime,\n        case when appt_timing='missed' then 'New' else appt_status end as `appt_status`,\n        case when appt_timing='missed' then 1 else 0 end as `missed`\n        from edc_appointment_appointment\n        where visit_code_sequence=0 and appt_datetime<=now()\n        order by subject_identifier, appt_datetime\n        )\n    select *, uuid() as `id`, now() as `created`, 'meta_reports.unattendedthreeinrow2' as `report_model` from (\n        select  distinct subject_identifier, site_id,  `first_value`, `second_value`, `third_value`,\n            datediff(third_date, first_date) as `interval_days`,\n            datediff(now(), first_date) as `from_now_days`,\n            `first_status`, `second_status`, `third_status`, sum(missed) as `missed_count`\n        from (\n            select subject_identifier,site_id,appt_datetime, missed,\n            FIRST_VALUE(appt_status) OVER w as `third_status`,\n            NTH_VALUE(appt_status, 2) OVER w as `second_status`,\n            NTH_VALUE(appt_status, 3) OVER w as `first_status`,\n            FIRST_VALUE(visit_code) OVER w as `third_value`,\n            NTH_VALUE(visit_code, 2) OVER w as `second_value`,\n            NTH_VALUE(visit_code, 3) OVER w as `first_value`,\n            FIRST_VALUE(appt_datetime) OVER w as `third_date`,\n            NTH_VALUE(appt_datetime, 2) OVER w as `second_date`,\n            NTH_VALUE(appt_datetime, 3) OVER w as `first_date`\n            from appointments\n            WINDOW w as (PARTITION BY subject_identifier order by appt_datetime desc ROWS UNBOUNDED PRECEDING)\n        ) as A\n        where `second_value` is not null and `third_value` is not null\n          and `first_status`='New'\n          and `second_status`='New'\n          and `third_status`='New'\n        group by subject_identifier, site_id,  `first_value`, `second_value`, `third_value`,\n                 datediff(`third_date`, `first_date`),\n                 datediff(now(), `first_date`),\n                 `first_status`, `second_status`, `third_status`\n        order by subject_identifier, site_id\n    ) as B",
                "unattended_three_in_row2_view",
                engine="django.db.backends.mysql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'with appointments as (select subject_identifier, site_id, visit_code, visit_code_sequence,\nappt_datetime, case when appt_timing="missed" then "New" else appt_status end as `appt_status`,\ncase when appt_timing="missed" then 1 else 0 end as `missed`\nfrom edc_appointment_appointment\nwhere visit_code_sequence=0 and appt_datetime<=now()\norder by subject_identifier, appt_datetime) select *, get_random_uuid() as id, now() as created, \'meta_reports.unattendedthreeinrow2\' as report_model from (SELECT DISTINCT subject_identifier, site_id, "first_value", "second_value", "third_value", CAST(AGE(CAST("third_date" AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT) AS interval_days, CAST(AGE(CAST(NOW() AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT) AS from_now_days, "first_status", "second_status", "third_status", SUM(missed) AS missed_count FROM (SELECT subject_identifier, site_id, appt_datetime, "missed", FIRST_VALUE(appt_status) OVER w AS "third_status", NTH_VALUE(appt_status, 2) OVER w AS "second_status", NTH_VALUE(appt_status, 3) OVER w AS "first_status", FIRST_VALUE(visit_code) OVER w AS "third_value", NTH_VALUE(visit_code, 2) OVER w AS "second_value", NTH_VALUE(visit_code, 3) OVER w AS "first_value", FIRST_VALUE(appt_datetime) OVER w AS "third_date", NTH_VALUE(appt_datetime, 2) OVER w AS "second_date", NTH_VALUE(appt_datetime, 3) OVER w AS "first_date" FROM appointments WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime DESC NULLS LAST ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT "second_value" IS NULL AND NOT "third_value" IS NULL AND "first_status" = \'New\' AND "second_status" = \'New\' AND "third_status" = \'New\' GROUP BY subject_identifier, site_id, "first_value", "second_value", "third_value", CAST(AGE(CAST("third_date" AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT), CAST(AGE(CAST(NOW() AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT), "first_status", "second_status", "third_status" ORDER BY subject_identifier NULLS FIRST, site_id NULLS FIRST) as A ORDER BY subject_identifier, site_id',
                "unattended_three_in_row2_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    with appointments as (\n        select subject_identifier, site_id, visit_code, visit_code_sequence, appt_datetime,\n        case when appt_timing='missed' then 'New' else appt_status end as appt_status,\n        case when appt_timing='missed' then 1 else 0 end as missed\n        from edc_appointment_appointment\n        where visit_code_sequence=0 and appt_datetime<=now()\n        order by subject_identifier, appt_datetime\n        )\n    select *, gen_random_uuid() as id, now() as created, 'meta_reports.unattendedthreeinrow2' as report_model\n    from (\n        select  distinct subject_identifier, site_id,  first_value, second_value, third_value,\n            EXTRACT(DAY FROM third_date - first_date) as interval_days,\n            EXTRACT(DAY FROM now() - first_date) as from_now_days,\n            first_status, second_status, third_status, sum(missed) as missed_count\n        from (\n            select subject_identifier,site_id,appt_datetime, missed,\n            FIRST_VALUE(appt_status) OVER w as third_status,\n            NTH_VALUE(appt_status, 2) OVER w as second_status,\n            NTH_VALUE(appt_status, 3) OVER w as first_status,\n            FIRST_VALUE(visit_code) OVER w as third_value,\n            NTH_VALUE(visit_code, 2) OVER w as second_value,\n            NTH_VALUE(visit_code, 3) OVER w as first_value,\n            FIRST_VALUE(appt_datetime) OVER w as third_date,\n            NTH_VALUE(appt_datetime, 2) OVER w as second_date,\n            NTH_VALUE(appt_datetime, 3) OVER w as first_date\n            from appointments\n            WINDOW w as (PARTITION BY subject_identifier order by appt_datetime desc ROWS UNBOUNDED PRECEDING)\n        ) as A\n        where second_value is not null and third_value is not null\n          and first_status='New'\n          and second_status='New'\n          and third_status='New'\n        group by subject_identifier, site_id,  first_value, second_value, third_value,\n                 EXTRACT(DAY FROM third_date - first_date),\n                 EXTRACT(DAY FROM now() - first_date),\n                 first_status, second_status, third_status\n        order by subject_identifier, site_id\n    ) as B",
                "unattended_three_in_row2_view",
                engine="django.db.backends.postgresql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'with appointments as (select subject_identifier, site_id, visit_code, visit_code_sequence,\nappt_datetime, case when appt_timing="missed" then "New" else appt_status end as `appt_status`,\ncase when appt_timing="missed" then 1 else 0 end as `missed`\nfrom edc_appointment_appointment\nwhere visit_code_sequence=0 and appt_datetime<=now()\norder by subject_identifier, appt_datetime) select *, uuid() as id, datetime() as created, \'meta_reports.unattendedthreeinrow2\' as report_model from (SELECT DISTINCT subject_identifier, site_id, "first_value", "second_value", "third_value", CAST((JULIANDAY("third_date") - JULIANDAY("first_date")) AS INTEGER) AS interval_days, CAST((JULIANDAY(NOW()) - JULIANDAY("first_date")) AS INTEGER) AS from_now_days, "first_status", "second_status", "third_status", SUM(missed) AS missed_count FROM (SELECT subject_identifier, site_id, appt_datetime, "missed", FIRST_VALUE(appt_status) OVER w AS "third_status", NTH_VALUE(appt_status, 2) OVER w AS "second_status", NTH_VALUE(appt_status, 3) OVER w AS "first_status", FIRST_VALUE(visit_code) OVER w AS "third_value", NTH_VALUE(visit_code, 2) OVER w AS "second_value", NTH_VALUE(visit_code, 3) OVER w AS "first_value", FIRST_VALUE(appt_datetime) OVER w AS "third_date", NTH_VALUE(appt_datetime, 2) OVER w AS "second_date", NTH_VALUE(appt_datetime, 3) OVER w AS "first_date" FROM appointments WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT "second_value" IS NULL AND NOT "third_value" IS NULL AND "first_status" = \'New\' AND "second_status" = \'New\' AND "third_status" = \'New\' GROUP BY subject_identifier, site_id, "first_value", "second_value", "third_value", CAST((JULIANDAY("third_date") - JULIANDAY("first_date")) AS INTEGER), CAST((JULIANDAY(NOW()) - JULIANDAY("first_date")) AS INTEGER), "first_status", "second_status", "third_status" ORDER BY subject_identifier, site_id) as A ORDER BY subject_identifier, site_id',
                "unattended_three_in_row2_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    with appointments as (\n        select subject_identifier, site_id, visit_code, visit_code_sequence, appt_datetime,\n        case when appt_timing='missed' then 'New' else appt_status end as `appt_status`,\n        case when appt_timing='missed' then 1 else 0 end as `missed`\n        from edc_appointment_appointment\n        where visit_code_sequence=0 and appt_datetime<=now()\n        order by subject_identifier, appt_datetime\n        )\n    SELECT *, lower(\n            hex(randomblob(4)) || '-' || hex(randomblob(2)) || '-' || '4' ||\n            substr(hex( randomblob(2)), 2) || '-' ||\n            substr('AB89', 1 + (abs(random()) % 4) , 1)  ||\n            substr(hex(randomblob(2)), 2) || '-' ||\n            hex(randomblob(6))\n          ) as id, datetime() as created, 'meta_reports.unattendedthreeinrow2' as report_model from (\n        select  distinct subject_identifier, site_id,  first_value, second_value, third_value,\n            CAST(JulianDay(third_date) - JulianDay(first_date) AS Integer) as interval_days,\n            CAST(JulianDay(datetime()) - JulianDay(first_date) AS Integer) as from_now_days,\n            first_status, second_status, third_status, sum(missed) as missed_count\n        from (\n            select subject_identifier,site_id,appt_datetime, missed,\n            FIRST_VALUE(appt_status) OVER w as third_status,\n            NTH_VALUE(appt_status, 2) OVER w as second_status,\n            NTH_VALUE(appt_status, 3) OVER w as first_status,\n            FIRST_VALUE(visit_code) OVER w as third_value,\n            NTH_VALUE(visit_code, 2) OVER w as second_value,\n            NTH_VALUE(visit_code, 3) OVER w as first_value,\n            FIRST_VALUE(appt_datetime) OVER w as third_date,\n            NTH_VALUE(appt_datetime, 2) OVER w as second_date,\n            NTH_VALUE(appt_datetime, 3) OVER w as first_date\n            from appointments\n            WINDOW w as (PARTITION BY subject_identifier order by appt_datetime desc ROWS UNBOUNDED PRECEDING)\n        ) as A\n        where second_value is not null and third_value is not null\n          and first_status='New'\n          and second_status='New'\n          and third_status='New'\n        group by subject_identifier, site_id,  first_value, second_value, third_value,\n                 CAST(JulianDay(third_date) - JulianDay(first_date) AS Integer),\n                 CAST(JulianDay(datetime()) - JulianDay(first_date) AS Integer),\n                 first_status, second_status, third_status\n        order by subject_identifier, site_id\n    ) as B",
                "unattended_three_in_row2_view",
                engine="django.db.backends.sqlite3",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                "select *, uuid() as id, now() as `created`, 'meta_reports.unattendedtwoinrow' as `report_model` from (SELECT subject_identifier, site_id, appt_datetime, `first_value`, `second_value`, DATEDIFF(`second_date`, `first_date`) AS interval_days, DATEDIFF(NOW(), `first_date`) AS from_now_days FROM (SELECT subject_identifier, site_id, appt_datetime, FIRST_VALUE(visit_code) OVER w AS `first_value`, NTH_VALUE(visit_code, 2) OVER w AS `second_value`, NTH_VALUE(visit_code, 3) OVER w AS `third_value`, FIRST_VALUE(appt_datetime) OVER w AS `first_date`, NTH_VALUE(appt_datetime, 2) OVER w AS `second_date` FROM edc_appointment_appointment WHERE visit_code_sequence = 0 AND appt_status = 'New' AND appt_datetime <= NOW() WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT `second_value` IS NULL AND `third_value` IS NULL) as A ORDER BY site_id, from_now_days desc",
                "unattended_two_in_row_view",
                engine="django.db.backends.mysql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    select *, uuid() as `id`, now() as `created`, 'meta_reports.unattendedtwoinrow' as report_model from (\n        select subject_identifier, site_id, appt_datetime, `first_value`, `second_value`,\n            datediff(`second_date`, `first_date`) as `interval_days`,\n            datediff(now(), `first_date`) as `from_now_days`\n            from (\n                select subject_identifier ,site_id, appt_datetime,\n                FIRST_VALUE(`visit_code`) OVER w as `first_value`,\n                NTH_VALUE(`visit_code`, 2) OVER w as `second_value`,\n                NTH_VALUE(`visit_code`, 3) OVER w as `third_value`,\n                FIRST_VALUE(`appt_datetime`) OVER w as `first_date`,\n                NTH_VALUE(`appt_datetime`, 2) OVER w as `second_date`\n                from edc_appointment_appointment where visit_code_sequence=0 and appt_status='New'\n                and appt_datetime <= now()\n                WINDOW w as (PARTITION BY subject_identifier order by appt_datetime ROWS UNBOUNDED PRECEDING)\n            ) as A1\n        where `second_value` is not null and `third_value` is null\n    ) as A2\n    order by site_id, `from_now_days` desc",
                "unattended_two_in_row_view",
                engine="django.db.backends.mysql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'select *, get_random_uuid() as id, now() as created, \'meta_reports.unattendedtwoinrow\' as report_model from (SELECT subject_identifier, site_id, appt_datetime, "first_value", "second_value", CAST(AGE(CAST("second_date" AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT) AS interval_days, CAST(AGE(CAST(NOW() AS TIMESTAMP), CAST("first_date" AS TIMESTAMP)) AS BIGINT) AS from_now_days FROM (SELECT subject_identifier, site_id, appt_datetime, FIRST_VALUE(visit_code) OVER w AS "first_value", NTH_VALUE(visit_code, 2) OVER w AS "second_value", NTH_VALUE(visit_code, 3) OVER w AS "third_value", FIRST_VALUE(appt_datetime) OVER w AS "first_date", NTH_VALUE(appt_datetime, 2) OVER w AS "second_date" FROM edc_appointment_appointment WHERE visit_code_sequence = 0 AND appt_status = \'New\' AND appt_datetime <= NOW() WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime NULLS FIRST ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT "second_value" IS NULL AND "third_value" IS NULL) as A ORDER BY site_id, from_now_days desc',
                "unattended_two_in_row_view",
                engine="django.db.backends.postgresql",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\n    select *, gen_random_uuid() as id, now() as created, 'meta_reports.unattendedtwoinrow' as report_model\n    from (\n        select subject_identifier, site_id, appt_datetime, first_value, second_value,\n            EXTRACT(DAY FROM second_date - first_date) as interval_days,\n            EXTRACT(DAY FROM now() - first_date) as from_now_days\n            from (\n                select subject_identifier, site_id, appt_datetime,\n                FIRST_VALUE(visit_code) OVER w as first_value,\n                NTH_VALUE(visit_code, 2) OVER w as second_value,\n                NTH_VALUE(visit_code, 3) OVER w as third_value,\n                FIRST_VALUE(appt_datetime) OVER w as first_date,\n                NTH_VALUE(appt_datetime, 2) OVER w as second_date\n                from edc_appointment_appointment where visit_code_sequence=0 and appt_status='New'\n                and appt_datetime <= now()\n                WINDOW w as (PARTITION BY subject_identifier order by appt_datetime ROWS UNBOUNDED PRECEDING)\n            ) as A1\n        where second_value is not null and third_value is null\n    ) as A2\n    order by site_id, from_now_days desc",
                "unattended_two_in_row_view",
                engine="django.db.backends.postgresql",
            ),
            atomic=False,
        ),
        django_db_views.operations.ViewRunPython(
            code=django_db_views.migration_functions.ForwardViewMigration(
                'select *, uuid() as id, datetime() as created, \'meta_reports.unattendedtwoinrow\' as report_model from (SELECT subject_identifier, site_id, appt_datetime, "first_value", "second_value", CAST((JULIANDAY("second_date") - JULIANDAY("first_date")) AS INTEGER) AS interval_days, CAST((JULIANDAY(NOW()) - JULIANDAY("first_date")) AS INTEGER) AS from_now_days FROM (SELECT subject_identifier, site_id, appt_datetime, FIRST_VALUE(visit_code) OVER w AS "first_value", NTH_VALUE(visit_code, 2) OVER w AS "second_value", NTH_VALUE(visit_code, 3) OVER w AS "third_value", FIRST_VALUE(appt_datetime) OVER w AS "first_date", NTH_VALUE(appt_datetime, 2) OVER w AS "second_date" FROM edc_appointment_appointment WHERE visit_code_sequence = 0 AND appt_status = \'New\' AND appt_datetime <= NOW() WINDOW w AS (PARTITION BY subject_identifier ORDER BY appt_datetime ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS B WHERE NOT "second_value" IS NULL AND "third_value" IS NULL) as A ORDER BY site_id, from_now_days desc',
                "unattended_two_in_row_view",
                engine="django.db.backends.sqlite3",
            ),
            reverse_code=django_db_views.migration_functions.BackwardViewMigration(
                "# noqa\nSELECT *, lower(\n    hex(randomblob(4)) || '-' || hex(randomblob(2)) || '-' || '4' ||\n    substr(hex( randomblob(2)), 2) || '-' ||\n    substr('AB89', 1 + (abs(random()) % 4) , 1)  ||\n    substr(hex(randomblob(2)), 2) || '-' ||\n    hex(randomblob(6))\n  ) as id, datetime() as created, 'meta_reports.unattendedtwoinrow' as report_model from (\n        select subject_identifier, site_id, appt_datetime, first_value, second_value,\n            CAST(JulianDay(second_date) - JulianDay(first_date) AS Integer) as interval_days,\n            CAST(JulianDay(datetime()) - JulianDay(first_date) AS Integer) as from_now_days\n            from (\n                select subject_identifier ,site_id, appt_datetime,\n                FIRST_VALUE(visit_code) OVER w as first_value,\n                NTH_VALUE(visit_code, 2) OVER w as second_value,\n                NTH_VALUE(visit_code, 3) OVER w as third_value,\n                FIRST_VALUE(appt_datetime) OVER w as first_date,\n                NTH_VALUE(appt_datetime, 2) OVER w as second_date\n                from edc_appointment_appointment where visit_code_sequence=0 and appt_status='New'\n                and appt_datetime <= datetime()\n                WINDOW w as (PARTITION BY subject_identifier order by appt_datetime ROWS UNBOUNDED PRECEDING)\n            ) as A1\n        where second_value is not null and third_value is null\n    ) as A2\n    order by site_id, from_now_days desc",
                "unattended_two_in_row_view",
                engine="django.db.backends.sqlite3",
            ),
            atomic=False,
        ),
    ]
