# Generated by Django 5.2.6 on 2025-09-24 05:45

import django.utils.timezone
import django_revision.revision_field
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "meta_screening",
            "0067_alter_historicalscreeningpartone_report_datetime_and_more",
        ),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="acute_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="acute_metabolic_acidosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="lactic acidosis and/or diabetic ketoacidosis",
                max_length=15,
                verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="alcoholism",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                max_length=15,
                verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="congestive_heart_failure",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                default="",
                max_length=15,
                verbose_name="Units (creatinine)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="has_dm",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to have diabetes?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="liver_disease",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                max_length=15,
                verbose_name="Is there clinical evidence of liver disease",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="meta_phase_two",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Was the subject enrolled in the <u>META Phase 2</u> trial?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="metformin_sensitivity",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                max_length=15,
                verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="on_dm_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to be taking anti-diabetic medications?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="p3_ltfu_comment",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="Provide any additional comments on this decision (or leave blank)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="reasons_ineligible",
            field=models.TextField(
                default="", max_length=150, verbose_name="Reason not eligible"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="reasons_ineligible_part_one",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="reasons_ineligible_part_three",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="reasons_ineligible_part_two",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="reasons_unsuitable",
            field=models.TextField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="Reason not suitable for the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="renal_function_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="Date and time of report.",
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date and Time",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="severe_htn",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                max_length=15,
                verbose_name="Does the patient have severe hypertension?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="staying_nearby_12",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for <u>at least 12 months</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="staying_nearby_6",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                editable=False,
                help_text="META PHASE_TWO ONLY",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="tissue_hypoxia_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="acute_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="acute_metabolic_acidosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="lactic acidosis and/or diabetic ketoacidosis",
                max_length=15,
                verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="alcoholism",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                max_length=15,
                verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="congestive_heart_failure",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                default="",
                max_length=15,
                verbose_name="Units (creatinine)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="has_dm",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to have diabetes?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="liver_disease",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                max_length=15,
                verbose_name="Is there clinical evidence of liver disease",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="meta_phase_two",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Was the subject enrolled in the <u>META Phase 2</u> trial?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="metformin_sensitivity",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                max_length=15,
                verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="on_dm_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to be taking anti-diabetic medications?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="p3_ltfu_comment",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="Provide any additional comments on this decision (or leave blank)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="reasons_ineligible",
            field=models.TextField(
                default="", max_length=150, verbose_name="Reason not eligible"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="reasons_ineligible_part_one",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="reasons_ineligible_part_three",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="reasons_ineligible_part_two",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="reasons_unsuitable",
            field=models.TextField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="Reason not suitable for the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="renal_function_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="Date and time of report.",
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date and Time",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="severe_htn",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                max_length=15,
                verbose_name="Does the patient have severe hypertension?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="staying_nearby_12",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for <u>at least 12 months</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="staying_nearby_6",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                editable=False,
                help_text="META PHASE_TWO ONLY",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="tissue_hypoxia_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="acute_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="acute_metabolic_acidosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="lactic acidosis and/or diabetic ketoacidosis",
                max_length=15,
                verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="alcoholism",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                max_length=15,
                verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="congestive_heart_failure",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                default="",
                max_length=15,
                verbose_name="Units (creatinine)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="has_dm",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to have diabetes?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="liver_disease",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                max_length=15,
                verbose_name="Is there clinical evidence of liver disease",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="meta_phase_two",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Was the subject enrolled in the <u>META Phase 2</u> trial?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="metformin_sensitivity",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                max_length=15,
                verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="on_dm_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to be taking anti-diabetic medications?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="p3_ltfu_comment",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="Provide any additional comments on this decision (or leave blank)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="reasons_ineligible",
            field=models.TextField(
                default="", max_length=150, verbose_name="Reason not eligible"
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="reasons_ineligible_part_one",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="reasons_ineligible_part_three",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="reasons_ineligible_part_two",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="reasons_unsuitable",
            field=models.TextField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="Reason not suitable for the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="renal_function_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="Date and time of report.",
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date and Time",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="severe_htn",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                max_length=15,
                verbose_name="Does the patient have severe hypertension?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="staying_nearby_12",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for <u>at least 12 months</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="staying_nearby_6",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                editable=False,
                help_text="META PHASE_TWO ONLY",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="tissue_hypoxia_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="other_reason",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=35,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectrefusal",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="acute_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="acute_metabolic_acidosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="lactic acidosis and/or diabetic ketoacidosis",
                max_length=15,
                verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="alcoholism",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                max_length=15,
                verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="congestive_heart_failure",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                default="",
                max_length=15,
                verbose_name="Units (creatinine)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="has_dm",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to have diabetes?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="liver_disease",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                max_length=15,
                verbose_name="Is there clinical evidence of liver disease",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="meta_phase_two",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Was the subject enrolled in the <u>META Phase 2</u> trial?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="metformin_sensitivity",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                max_length=15,
                verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="on_dm_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to be taking anti-diabetic medications?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="p3_ltfu_comment",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="Provide any additional comments on this decision (or leave blank)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="reasons_ineligible",
            field=models.TextField(
                default="", max_length=150, verbose_name="Reason not eligible"
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="reasons_ineligible_part_one",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="reasons_ineligible_part_three",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="reasons_ineligible_part_two",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="reasons_unsuitable",
            field=models.TextField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="Reason not suitable for the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="renal_function_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="Date and time of report.",
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date and Time",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="severe_htn",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                max_length=15,
                verbose_name="Does the patient have severe hypertension?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="staying_nearby_12",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for <u>at least 12 months</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="staying_nearby_6",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                editable=False,
                help_text="META PHASE_TWO ONLY",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="tissue_hypoxia_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="other_reason",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=35,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="subjectrefusal",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="acute_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="acute_metabolic_acidosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="lactic acidosis and/or diabetic ketoacidosis",
                max_length=15,
                verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="alcoholism",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                max_length=15,
                verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="congestive_heart_failure",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                default="",
                max_length=15,
                verbose_name="Units (creatinine)",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="has_dm",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to have diabetes?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="liver_disease",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                max_length=15,
                verbose_name="Is there clinical evidence of liver disease",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="meta_phase_two",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Was the subject enrolled in the <u>META Phase 2</u> trial?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="metformin_sensitivity",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                max_length=15,
                verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="on_dm_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient known to be taking anti-diabetic medications?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="p3_ltfu_comment",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="Provide any additional comments on this decision (or leave blank)",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="reasons_ineligible",
            field=models.TextField(
                default="", max_length=150, verbose_name="Reason not eligible"
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="reasons_ineligible_part_one",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="reasons_ineligible_part_three",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="reasons_ineligible_part_two",
            field=models.TextField(default="", editable=False, max_length=150),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="reasons_unsuitable",
            field=models.TextField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="Reason not suitable for the study",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="renal_function_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="Date and time of report.",
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date and Time",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="severe_htn",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                max_length=15,
                verbose_name="Does the patient have severe hypertension?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="staying_nearby_12",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for <u>at least 12 months</u>",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="staying_nearby_6",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                editable=False,
                help_text="META PHASE_TWO ONLY",
                max_length=15,
                verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="subject_identifier_aka",
            field=models.CharField(
                default="",
                editable=False,
                help_text="track a previously allocated identifier.",
                max_length=50,
                verbose_name="Subject Identifier a.k.a",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="tissue_hypoxia_condition",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                max_length=15,
                verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
            ),
        ),
    ]
