# Generated by Django 5.0.1 on 2024-02-13 00:03

import django.core.validators
import edc_model_fields.fields.other_charfield
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_lists", "0017_complications_dmmedications_dmtreatments_and_more"),
        ("meta_subject", "0165_alter_dmreferralfollowup_healthcare_workers"),
    ]

    operations = [
        migrations.RenameField(
            model_name="dmreferralfollowup",
            old_name="dm_medications_other",
            new_name="other_dm_medications",
        ),
        migrations.RenameField(
            model_name="dmreferralfollowup",
            old_name="investigations_other",
            new_name="other_investigations",
        ),
        migrations.RenameField(
            model_name="historicaldmreferralfollowup",
            old_name="dm_medications_other",
            new_name="other_dm_medications",
        ),
        migrations.RenameField(
            model_name="historicaldmreferralfollowup",
            old_name="investigations_other",
            new_name="other_investigations",
        ),
        migrations.AddField(
            model_name="dmreferralfollowup",
            name="complications_checks_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Was the patient checked for diabetes related complications at this visit?",
            ),
        ),
        migrations.AddField(
            model_name="dmreferralfollowup",
            name="other_complications_checks",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other 'diabetes related complications checked for ', please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="dmreferralfollowup",
            name="treatment_prescribed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Was any treatment prescribed at this visit?",
            ),
        ),
        migrations.AddField(
            model_name="historicaldmreferralfollowup",
            name="complications_checks_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Was the patient checked for diabetes related complications at this visit?",
            ),
        ),
        migrations.AddField(
            model_name="historicaldmreferralfollowup",
            name="other_complications_checks",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other 'diabetes related complications checked for ', please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaldmreferralfollowup",
            name="treatment_prescribed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Was any treatment prescribed at this visit?",
            ),
        ),
        migrations.AlterField(
            model_name="dmreferralfollowup",
            name="complications_checks",
            field=models.ManyToManyField(
                blank=True,
                to="meta_lists.complications",
                verbose_name="If 'Yes, which diabetes related complications were checked for?",
            ),
        ),
        migrations.AlterField(
            model_name="dmreferralfollowup",
            name="dm_medications",
            field=models.ManyToManyField(
                blank=True,
                to="meta_lists.dmmedications",
                verbose_name="If ‘Yes’, please indicate which diabetes drug treatments you are currently taking.",
            ),
        ),
        migrations.AlterField(
            model_name="dmreferralfollowup",
            name="dm_treatments",
            field=models.ManyToManyField(
                blank=True,
                to="meta_lists.dmtreatments",
                verbose_name="What treatment was prescribed?",
            ),
        ),
        migrations.AlterField(
            model_name="dmreferralfollowup",
            name="investigations_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Were any further investigations conducted at this visit?",
            ),
        ),
        migrations.AlterField(
            model_name="dmreferralfollowup",
            name="visual_score_confirmed",
            field=models.IntegerField(
                blank=True,
                help_text="%",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="<B><font color='orange'>Interviewer</font></B>: please transcribe the score indicated from above.",
            ),
        ),
        migrations.AlterField(
            model_name="dmreferralfollowup",
            name="visual_score_slider",
            field=models.CharField(
                blank=True, help_text="%", max_length=3, null=True, verbose_name="Visual score"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldmreferralfollowup",
            name="investigations_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Were any further investigations conducted at this visit?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldmreferralfollowup",
            name="visual_score_confirmed",
            field=models.IntegerField(
                blank=True,
                help_text="%",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="<B><font color='orange'>Interviewer</font></B>: please transcribe the score indicated from above.",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldmreferralfollowup",
            name="visual_score_slider",
            field=models.CharField(
                blank=True, help_text="%", max_length=3, null=True, verbose_name="Visual score"
            ),
        ),
    ]
