# Generated by Django 5.0.1 on 2024-02-14 19:39
from django.db import migrations
from django.db.migrations import RunPython
from tqdm import tqdm


def update_refill_end_datetime(apps, schema_editor):
    model_cls = apps.get_model("meta_subject.studymedication")
    qs = model_cls.objects.filter(refill_end_datetime__isnull=True).order_by(
        "subject_visit__subject_identifier"
    )
    total = qs.count()
    for obj in tqdm(qs, total=total):
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0174_remove_glucosefbg_glucose_abnormal_and_more"),
    ]

    operations = [RunPython(update_refill_end_datetime)]
