# Generated by Django 5.0.8 on 2024-08-27 19:22

from django.db import migrations
from django.db.migrations import RunPython
from clinicedc_constants import NO, YES


def update_old_fasting_choices(apps, schema_editor):
    result = {"fasting": 0, "non_fasting": 0}
    model_cls = apps.get_model("meta_subject.glucosefbg")
    result["fasting"] = model_cls.objects.filter(fasting="fasting").update(fasting=YES)
    result["non_fasting"] = model_cls.objects.filter(fasting="non_fasting").update(fasting=NO)
    print(f"Updated: results are {result}")
    print("Done.")


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0211_dmendpoint_endpoint_reached_and_more"),
    ]

    operations = [RunPython(update_old_fasting_choices)]
