# Generated by Django 6.0 on 2025-02-27 06:56

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django.utils.timezone
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("edc_action_item", "0037_remove_actionitem_reference_model_and_more"),
        (
            "meta_subject",
            "0219_remove_historicalnextappointment_allow_create_interim_and_more",
        ),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalBloodResultsGluDummy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                ("consent_model", models.CharField(blank=True, max_length=50, null=True)),
                ("consent_version", models.CharField(blank=True, max_length=10, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.99),
                        ],
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "glucose_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "glucose_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "glucose_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "glucose_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        choices=[("fasting", "Fasting"), ("non_fasting", "Non-fasting")],
                        max_length=25,
                        null=True,
                        verbose_name="Was this fasting or non-fasting?",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "blood_glucose"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: Glucose (DUMMY)",
                "verbose_name_plural": "historical Blood Results: Glucose (DUMMY)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="BloodResultsGluDummy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                ("consent_model", models.CharField(blank=True, max_length=50, null=True)),
                ("consent_version", models.CharField(blank=True, max_length=10, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.99),
                        ],
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "glucose_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "glucose_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "glucose_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "glucose_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        choices=[("fasting", "Fasting"), ("non_fasting", "Non-fasting")],
                        max_length=25,
                        null=True,
                        verbose_name="Was this fasting or non-fasting?",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "blood_glucose"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="meta_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: Glucose (DUMMY)",
                "verbose_name_plural": "Blood Results: Glucose (DUMMY)",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site"], name="meta_subjec_subject_deb149_idx"
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="meta_subjec_subject_d7610d_idx",
                    ),
                ],
            },
            managers=[
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
            ],
        ),
    ]
