# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements. See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership. The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License. You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied. See the License for the
# specific language governing permissions and limitations
# under the License.

import setuptools

with open("README.md") as f:
  long_description = f.read()

with open('requirements.txt') as f:
  requirements = f.read().splitlines()

setuptools.setup(
    name="md2ipynb",
    version="0.1.2",
    author="David Cavazos",
    author_email="dcavazosw@gmail.com",
    description="Markdown to Jupyter Notebook converter.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/davidcavazos/md2ipynb",
    packages=setuptools.find_packages(),
    install_requires=requirements,
    test_suite='nose.collector',
    tests_require=['nose'],
    entry_points={
        'console_scripts': [
            'md2ipynb = md2ipynb.__main__:main'
        ],
    },
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Topic :: Software Development :: Build Tools",
        "Topic :: Software Development :: Code Generators",
        "Topic :: Software Development :: Compilers",
    ],
)