from langchain_ollama import ChatOllama, OllamaLLM
from langchain_core.messages import AIMessage, ToolMessage, HumanMessage
from pydantic import BaseModel as PydanticModel, Field
from functools import lru_cache

from .base import BaseArchytasModel, EnvironmentAuth, ModelConfig



class OllamaModel(BaseArchytasModel):
    DEFAULT_MODEL = "llama3"

    MODEL_PROMPT_INSTRUCTIONS = """
If you receieve a message with a role of `tool` in response to a tool being called, the user has not seen the content
of that message. Those messages are generated by the system and sent to you for review as part of the ReAct loop. Please
treat such messages as a response from a third party that provide more information for you to use to help achieve the
user's task.
Be sure to always use the `final_answer` tool to report back to the user.
"""

    def auth(self, **kwargs) -> None:
        return

    def initialize_model(self, **kwargs):
        # Dummy tool in required to enable "tool mode" on the model
        return ChatOllama(model=self.config.model_name or self.DEFAULT_MODEL)
    
    def ainvoke(self, input, *, config=None, stop=None, **kwargs):
        if "temperature" in kwargs:
            if "options" not in kwargs:
                kwargs["options"] = {"temperature": kwargs.pop("temperature")}
            else:
                kwargs["options"].update({"temperature": kwargs.pop("temperature")})
        return super().ainvoke(input, config=config, stop=stop, **kwargs)
    
    @lru_cache()
    def contextsize(self, model_name: str | None) -> int | None:
        if model_name is None:
            model_name = self.model_name
        show_response = self.model._client.show(self.model_name)
        model_info = show_response.modelinfo
        try:
            model_arch = model_info["general.architecture"]
            context_length = model_info[f"{model_arch}.context_length"]
            return int(context_length)
        except KeyError:
            print("No context length in model info")
            return None
