"""init

迁移 ID: 3537b7cb6a29
父迁移: None
创建时间: 2025-08-16 14:55:36.587020

"""

from __future__ import annotations

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

revision: str = "3537b7cb6a29"
down_revision: str | Sequence[str] | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "suggarchat_memory_data",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("ins_id", sa.Integer(), nullable=False),
        sa.Column("is_group", sa.Boolean(), nullable=False),
        sa.Column(
            "messages_json", sa.Text(), nullable=False, server_default=sa.text("'{}'")
        ),
        sa.Column(
            "sessions_json", sa.Text(), nullable=False, server_default=sa.text("'[]'")
        ),
        sa.Column("time", sa.DateTime(), nullable=False),
        sa.Column("usage_count", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_suggarchat_memory_data")),
        sa.UniqueConstraint("ins_id", "is_group", name="uq_ins_id_is_group"),
        info={"bind_key": "nonebot_plugin_suggarchat"},
    )
    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.create_index("idx_ins_id", ["ins_id"], unique=False)
        batch_op.create_index("idx_is_group", ["is_group"], unique=False)

    op.create_table(
        "suggarchat_group_config",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("group_id", sa.Integer(), nullable=False),
        sa.Column("enable", sa.Boolean(), nullable=False),
        sa.Column("prompt", sa.Text(), nullable=False),
        sa.Column("fake_people", sa.Boolean(), nullable=False),
        sa.Column("last_updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["group_id"],
            ["suggarchat_memory_data.ins_id"],
            name=op.f("fk_suggarchat_group_config_group_id_suggarchat_memory_data"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_suggarchat_group_config")),
        sa.UniqueConstraint("group_id", name="uq_suggarchat_config_group_id"),
        info={"bind_key": "nonebot_plugin_suggarchat"},
    )
    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.create_index("idx_suggarchat_group_id", ["group_id"], unique=False)

    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.drop_index("idx_suggarchat_group_id")

    op.drop_table("suggarchat_group_config")
    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.drop_index("idx_is_group")
        batch_op.drop_index("idx_ins_id")

    op.drop_table("suggarchat_memory_data")
    # ### end Alembic commands ###
