"""usage

迁移 ID: ec1f1e46989b
父迁移: 1d99948099bb
创建时间: 2025-08-17 09:55:17.498999

"""

from __future__ import annotations

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

revision: str = "ec1f1e46989b"
down_revision: str | Sequence[str] | None = "1d99948099bb"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic and JohnRichard4096 :) ###

    # op.drop_table("_alembic_tmp_suggarchat_group_config")
    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_suggarchat_group_config_group_id_suggarchat_memory_data"),
            type_="foreignkey",
        )

    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "input_token_usage",
                sa.BigInteger(),
                nullable=False,
                server_default=sa.text("0"),
            )
        )
        batch_op.add_column(
            sa.Column(
                "output_token_usage",
                sa.BigInteger(),
                nullable=False,
                server_default=sa.text("0"),
            )
        )
    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.alter_column(
            "group_id",
            existing_type=sa.INTEGER(),
            type_=sa.BigInteger(),
            existing_nullable=False,
        )

    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.alter_column(
            "ins_id",
            existing_type=sa.INTEGER(),
            type_=sa.BigInteger(),
            existing_nullable=False,
        )
    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.create_foreign_key(
            batch_op.f("fk_suggarchat_group_config_group_id_suggarchat_memory_data"),
            "suggarchat_memory_data",
            ["group_id"],
            ["ins_id"],
        )

    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic and JohnRichard4096 :) - please adjust! ###

    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_suggarchat_group_config_group_id_suggarchat_memory_data"),
            type_="foreignkey",
        )
    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.alter_column(
            "ins_id",
            existing_type=sa.BigInteger(),
            type_=sa.INTEGER(),
            existing_nullable=False,
        )

    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.alter_column(
            "group_id",
            existing_type=sa.BigInteger(),
            type_=sa.INTEGER(),
            existing_nullable=False,
        )
    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.drop_column("output_token_usage")
        batch_op.drop_column("input_token_usage")

    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.create_foreign_key(
            batch_op.f("fk_suggarchat_group_config_group_id_suggarchat_memory_data"),
            "suggarchat_memory_data",
            ["group_id"],
            ["ins_id"],
        )
    """
    op.create_table(
        "_alembic_tmp_suggarchat_group_config",
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.Column("group_id", sa.INTEGER(), nullable=False),
        sa.Column("enable", sa.BOOLEAN(), nullable=False),
        sa.Column("prompt", sa.TEXT(), nullable=False),
        sa.Column("fake_people", sa.BOOLEAN(), nullable=False),
        sa.Column("last_updated", sa.DATETIME(), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_suggarchat_group_config")),
        sa.UniqueConstraint("group_id", name=op.f("uq_suggarchat_config_group_id")),
    )
    """

    # ### end Alembic commands ###


"""def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.alter_column(
            "group_id",
            existing_type=sa.INTEGER(),
            type_=sa.BigInteger(),
            existing_nullable=False,
        )

    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("input_token_usage", sa.BigInteger(), nullable=False)
        )
        batch_op.add_column(
            sa.Column("output_token_usage", sa.BigInteger(), nullable=False)
        )
        batch_op.alter_column(
            "ins_id",
            existing_type=sa.INTEGER(),
            type_=sa.BigInteger(),
            existing_nullable=False,
        )

    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("suggarchat_memory_data", schema=None) as batch_op:
        batch_op.alter_column(
            "ins_id",
            existing_type=sa.BigInteger(),
            type_=sa.INTEGER(),
            existing_nullable=False,
        )
        batch_op.drop_column("output_token_usage")
        batch_op.drop_column("input_token_usage")

    with op.batch_alter_table("suggarchat_group_config", schema=None) as batch_op:
        batch_op.alter_column(
            "group_id",
            existing_type=sa.BigInteger(),
            type_=sa.INTEGER(),
            existing_nullable=False,
        )

    # ### end Alembic commands ###
"""
