

# Llama 4 - Prompt Formats
## Tokens
Here is a list of special tokens that are supported by Llama 4:
- `<|begin_of_text|>`: Specifies the start of the prompt
- `<|end_of_text|>`: Model will cease to generate more tokens. This token is generated only by the base models.
- `<|header_start|>` and `<|header_end|>`: These tokens enclose the role for a particular message. The possible roles are: [system, user and assistant].
- `<|eot|>`: End of turn. Represents when the model has determined that it has finished interacting with the user message that initiated its response. This is used in two scenarios:
    - at the end of a direct interaction between the model and the user
    - at the end of multiple interactions between the model and any available tools
    This token signals to the executor that the model has finished generating a response.
- `<|image_start|>` and `<|image_end|>`: These tokens enclose the image data in the prompt.
- `<|patch|>`: This token represents a piece of the tile/
- `<|tile_y_separator|>` and `<|tile_x_separator|>`: These tokens are used to separate the y and x tiles of an image
- `<|image|>`: In the new architecture, this token now separates the regular sized image information from a downsized version of it that fits in a single tile. The longer side is used for calculating the scale factor and the rest is padded to fit the tile.



There are 3 different roles that are supported by Llama 4
- `system`: Sets the context in which to interact with the AI model. It typically includes rules, guidelines, or necessary information that helps the model respond effectively.
- `user`: Represents the human interacting with the model. It includes the inputs, commands, and questions to the model.
- `assistant`: Represents the response generated by the AI model based on the context provided in the `system`, `tool` and `user` prompts.


# Llama 4 Instruct Model
## Simple User and assistant conversation

Here is a regular multi-turn user assistant conversation and how its formatted.

##### Input Prompt Format
```
<|begin_of_text|><|header_start|>system<|header_end|>

You are a helpful assistant<|eot|><|header_start|>user<|header_end|>

Answer who are you in the form of jeopardy?<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
"What is a helpful assistant?"<|eot|>
```





# Image prompt format
## Single image prompt format - small image

This example passes an image that is smaller than the tile size, to show the tile separator tokens are not needed

##### Input Prompt Format
```
<|begin_of_text|><|header_start|>user<|header_end|>

<|image_start|><|image|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|image_end|>Describe this image in two sentences<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
The image depicts a dog standing on a skateboard, positioned centrally and facing the camera directly. The dog has a distinctive coat pattern featuring white, black, and brown fur, with floppy ears and a black nose, and is standing on a skateboard with red wheels.<|eot|>
```


##### Notes
Notice the structure of the image section:
        ```
        <|image_start|><|image|><|patch|>...<|patch|><|image_end|>
        ```
        This is due to the image being smaller than the tile size.


## Single image prompt format

Here is an example of how to pass an image to the model

##### Input Prompt Format
```
<|begin_of_text|><|header_start|>user<|header_end|>

<|image_start|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|image|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|image_end|>Describe this image in two sentences<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
The image depicts a dog standing on a skateboard, with the dog positioned centrally and facing forward. The dog has a distinctive coat featuring a mix of white, brown, and black fur, and is wearing a collar as it stands on the skateboard, which has red wheels.<|eot|>
```


##### Notes
With a bigger image, the image will include the tile separator tokens. Additionally, the image tag now separates a scaled down version of the image from the regular sized image.
        ```
        <|image_start|><|patch|>...<|patch|><|tile_x_separator|><|patch|>...<|patch|><|tile_y_separator|><|patch|>...<|patch|><|image|><|patch|>...<|patch|><|image_end|>
        ```


## Multiple images prompt format

Here is an example of how to pass an image to the model

##### Input Prompt Format
```
<|begin_of_text|><|header_start|>user<|header_end|>

<|image_start|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|image|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|image_end|><|image_start|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_x_separator|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|tile_y_separator|><|image|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|patch|><|image_end|>Describe these images in two sentences<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
The first image features a dog standing on a skateboard, while the second image showcases a plate of spaghetti with tomato sauce and cheese. The two images appear to be unrelated, with one depicting a playful scene of a dog on a skateboard and the other presenting a classic Italian dish.<|eom|>
```


##### Notes
With multiple images, each one is encapsulated in their corresponding image tags.


# Tool calling
We are continuing the format for zero shot function calling used in previous versions of Llama. All available functions can be provided either in the system message or in the user message.
## Zero shot function calling - system message



##### Input Prompt Format
```
<|begin_of_text|><|header_start|>system<|header_end|>

You are a helpful assistant and an expert in function composition. You can answer general questions using your internal knowledge OR invoke functions when necessary. Follow these strict guidelines:

1. FUNCTION CALLS:
- ONLY use functions that are EXPLICITLY listed in the function list below
- If NO functions are listed (empty function list []), respond ONLY with internal knowledge or "I don't have access to [Unavailable service] information"
- If a function is not in the list, respond ONLY with internal knowledge or "I don't have access to [Unavailable service] information"
- If ALL required parameters are present AND the query EXACTLY matches a listed function's purpose: output ONLY the function call(s)
- Use exact format: [func_name1(param1=value1, param2=value2), func_name2(...)]
Examples:
CORRECT: [get_weather(location="Vancouver"), calculate_route(start="Boston", end="New York")] <- Only if get_weather and calculate_route are in function list
INCORRECT: get_weather(location="New York")
INCORRECT: Let me check the weather: [get_weather(location="New York")]
INCORRECT: [get_events(location="Singapore")] <- If function not in list

2. RESPONSE RULES:
- For pure function requests matching a listed function: ONLY output the function call(s)
- For knowledge questions: ONLY output text
- For missing parameters: ONLY request the specific missing parameters
- For unavailable services (not in function list): output ONLY with internal knowledge or "I don't have access to [Unavailable service] information". Do NOT execute a function call.
- If the query asks for information beyond what a listed function provides: output ONLY with internal knowledge about your limitations
- NEVER combine text and function calls in the same response
- NEVER suggest alternative functions when the requested service is unavailable
- NEVER create or invent new functions not listed below

3. STRICT BOUNDARIES:
- ONLY use functions from the list below - no exceptions
- NEVER use a function as an alternative to unavailable information
- NEVER call functions not present in the function list
- NEVER add explanatory text to function calls
- NEVER respond with empty brackets
- Use proper Python/JSON syntax for function calls
- Check the function list carefully before responding

4. TOOL RESPONSE HANDLING:
- When receiving tool responses: provide concise, natural language responses
- Don't repeat tool response verbatim
- Don't add supplementary information

Here is a list of functions in JSON format that you can invoke:
[
    {
        "name": "get_weather",
        "description": "Get weather info for places",
        "parameters": {
            "type": "dict",
            "required": ["city"],
            "properties": {
                "city": {
                    "type": "string",
                    "description": "The name of the city to get the weather for"
                },
                "metric": {
                    "type": "string",
                    "description": "The metric for weather. Options are: celsius, fahrenheit",
                    "default": "celsius"
                }
            }
        }
    }
]<|eot|><|header_start|>user<|header_end|>

What is the weather in SF and Seattle?<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
[get_weather(city="San Francisco"), get_weather(city="Seattle")]<|eot|>
```


##### Notes

- The output supports multiple, and parallel tool calls natively
- JSON format for defining the functions in the system prompt is similar to Llama3.1


## Zero shot function calling - user message


Similar to the above example, you can also provide information for all the available tools in the user message.


##### Input Prompt Format
```
<|begin_of_text|><|header_start|>user<|header_end|>

Questions: Can you retrieve the details for the user with the ID 7890, who has black as their special request?
Here is a list of functions in JSON format that you can invoke:
[
    {
        "name": "get_user_info",
        "description": "Retrieve details for a specific user by their unique identifier. Note that the provided function is in Python 3 syntax.",
        "parameters": {
            "type": "dict",
            "required": [
                "user_id"
            ],
            "properties": {
                "user_id": {
                "type": "integer",
                "description": "The unique identifier of the user. It is used to fetch the specific user details from the database."
            },
            "special": {
                "type": "string",
                "description": "Any special information or parameters that need to be considered while fetching user details.",
                "default": "none"
                }
            }
        }
    }
]

Should you decide to return the function call(s), put them in the format of [func1(params_name=params_value, params_name2=params_value2...), func2(params)]

You SHOULD NOT include any other text in the response.<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
[get_user_info(user_id=7890, special='black')]<|eot|>
```


##### Notes

- The tool call format for the model is the same whether your function calls are provided in the system or user message.


## Tool calling with custom formats


Here is an example of how you could also write custom instructions for model to do zero shot tool calling.
In this example, we define a custom tool calling format using the `<function>` tag.


##### Input Prompt Format
```
<|begin_of_text|><|header_start|>user<|header_end|>

You have access to the following functions:
Use the function 'trending_songs' to 'Returns the trending songs on a Music site':
{"name": "trending_songs", "description": "Returns the trending songs on a Music site", "parameters": {"genre": {"description": "The genre of the songs to return", "param_type": "str", "required": false}, "n": {"description": "The number of songs to return", "param_type": "int", "required": true}}}

Think very carefully before calling functions.
If you choose to call a function ONLY reply in the following format with no prefix or suffix:

<function=example_function_name>{"example_name": "example_value"}</function>
Reminder:
- If looking for real time information use relevant functions before falling back to brave_search
- Function calls MUST follow the specified format, start with <function= and end with </function>
- Required parameters MUST be specified
- Only call one function at a time
- Put the entire function call reply on one line<|eot_id|><|eot|><|header_start|>user<|header_end|>

Use tools to get latest trending songs<|eot|><|header_start|>assistant<|header_end|>


```

##### Model Response Format
```
<function=trending_songs>{"n": 10}</function><|eot|>
```
