# cyperf
CyPerf REST API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.7.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.11+

## Installation & Usage
### pip install

You can install directly by doing:

```sh
pip install .
```

from the base of this repository.

Then import the package:
```python
import cyperf
```
### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import cyperf
from cyperf.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cyperf.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.refresh_token = os.environ["OFFLINE_TOKEN_FROM_CYPERF_UI"]

configuration.refresh_token = os.environ["OFFLINE_TOKEN_FROM_CYPERF_UI"]


# Enter a context with an instance of the API client
with cyperf.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cyperf.AgentsApi(api_client)
    agent_id = 'agent_id_example' # str | The ID of the agent.

    try:
        api_instance.delete_agent(agent_id)
    except ApiException as e:
        print("Exception when calling AgentsApi->delete_agent: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentsApi* | [**delete_agent**](docs/AgentsApi.md#delete_agent) | **DELETE** /api/v2/agents/{agentId} | 
*AgentsApi* | [**get_agent_by_id**](docs/AgentsApi.md#get_agent_by_id) | **GET** /api/v2/agents/{agentId} | 
*AgentsApi* | [**get_agents**](docs/AgentsApi.md#get_agents) | **GET** /api/v2/agents | 
*AgentsApi* | [**get_agents_tags**](docs/AgentsApi.md#get_agents_tags) | **GET** /api/v2/tags | 
*AgentsApi* | [**get_compute_node_port_by_id**](docs/AgentsApi.md#get_compute_node_port_by_id) | **GET** /api/v2/controllers/{controllerId}/compute-nodes/{computeNodeId}/ports/{portId} | 
*AgentsApi* | [**get_compute_node_ports**](docs/AgentsApi.md#get_compute_node_ports) | **GET** /api/v2/controllers/{controllerId}/compute-nodes/{computeNodeId}/ports | 
*AgentsApi* | [**get_controller_by_id**](docs/AgentsApi.md#get_controller_by_id) | **GET** /api/v2/controllers/{controllerId} | 
*AgentsApi* | [**get_controller_compute_node_by_id**](docs/AgentsApi.md#get_controller_compute_node_by_id) | **GET** /api/v2/controllers/{controllerId}/compute-nodes/{computeNodeId} | 
*AgentsApi* | [**get_controller_compute_nodes**](docs/AgentsApi.md#get_controller_compute_nodes) | **GET** /api/v2/controllers/{controllerId}/compute-nodes | 
*AgentsApi* | [**get_controllers**](docs/AgentsApi.md#get_controllers) | **GET** /api/v2/controllers | 
*AgentsApi* | [**patch_agent**](docs/AgentsApi.md#patch_agent) | **PATCH** /api/v2/agents/{agentId} | 
*AgentsApi* | [**poll_agents_batch_delete**](docs/AgentsApi.md#poll_agents_batch_delete) | **GET** /api/v2/agents/operations/batch-delete/{id} | 
*AgentsApi* | [**poll_agents_export_files**](docs/AgentsApi.md#poll_agents_export_files) | **GET** /api/v2/agents/operations/exportFiles/{id} | 
*AgentsApi* | [**poll_agents_reboot**](docs/AgentsApi.md#poll_agents_reboot) | **GET** /api/v2/agents/operations/reboot/{id} | 
*AgentsApi* | [**poll_agents_release**](docs/AgentsApi.md#poll_agents_release) | **GET** /api/v2/agents/operations/release/{id} | 
*AgentsApi* | [**poll_agents_reserve**](docs/AgentsApi.md#poll_agents_reserve) | **GET** /api/v2/agents/operations/reserve/{id} | 
*AgentsApi* | [**poll_agents_set_dpdk_mode**](docs/AgentsApi.md#poll_agents_set_dpdk_mode) | **GET** /api/v2/agents/operations/set-dpdk-mode/{id} | 
*AgentsApi* | [**poll_agents_set_ntp**](docs/AgentsApi.md#poll_agents_set_ntp) | **GET** /api/v2/agents/operations/set-ntp/{id} | 
*AgentsApi* | [**poll_agents_update**](docs/AgentsApi.md#poll_agents_update) | **GET** /api/v2/agents/operations/update/{id} | 
*AgentsApi* | [**poll_controllers_clear_port_ownership**](docs/AgentsApi.md#poll_controllers_clear_port_ownership) | **GET** /api/v2/controllers/operations/clear-port-ownership/{id} | 
*AgentsApi* | [**poll_controllers_power_cycle_nodes**](docs/AgentsApi.md#poll_controllers_power_cycle_nodes) | **GET** /api/v2/controllers/operations/power-cycle-nodes/{id} | 
*AgentsApi* | [**poll_controllers_reboot_port**](docs/AgentsApi.md#poll_controllers_reboot_port) | **GET** /api/v2/controllers/operations/reboot-port/{id} | 
*AgentsApi* | [**poll_controllers_set_app**](docs/AgentsApi.md#poll_controllers_set_app) | **GET** /api/v2/controllers/operations/set-app/{id} | 
*AgentsApi* | [**poll_controllers_set_node_aggregation**](docs/AgentsApi.md#poll_controllers_set_node_aggregation) | **GET** /api/v2/controllers/operations/set-node-aggregation/{id} | 
*AgentsApi* | [**poll_controllers_set_port_link_state**](docs/AgentsApi.md#poll_controllers_set_port_link_state) | **GET** /api/v2/controllers/operations/set-port-link-state/{id} | 
*AgentsApi* | [**start_agents_batch_delete**](docs/AgentsApi.md#start_agents_batch_delete) | **POST** /api/v2/agents/operations/batch-delete | 
*AgentsApi* | [**start_agents_export_files**](docs/AgentsApi.md#start_agents_export_files) | **POST** /api/v2/agents/operations/exportFiles | 
*AgentsApi* | [**start_agents_reboot**](docs/AgentsApi.md#start_agents_reboot) | **POST** /api/v2/agents/operations/reboot | 
*AgentsApi* | [**start_agents_release**](docs/AgentsApi.md#start_agents_release) | **POST** /api/v2/agents/operations/release | 
*AgentsApi* | [**start_agents_reserve**](docs/AgentsApi.md#start_agents_reserve) | **POST** /api/v2/agents/operations/reserve | 
*AgentsApi* | [**start_agents_set_dpdk_mode**](docs/AgentsApi.md#start_agents_set_dpdk_mode) | **POST** /api/v2/agents/operations/set-dpdk-mode | 
*AgentsApi* | [**start_agents_set_ntp**](docs/AgentsApi.md#start_agents_set_ntp) | **POST** /api/v2/agents/operations/set-ntp | 
*AgentsApi* | [**start_agents_update**](docs/AgentsApi.md#start_agents_update) | **POST** /api/v2/agents/operations/update | 
*AgentsApi* | [**start_controllers_clear_port_ownership**](docs/AgentsApi.md#start_controllers_clear_port_ownership) | **POST** /api/v2/controllers/operations/clear-port-ownership | 
*AgentsApi* | [**start_controllers_power_cycle_nodes**](docs/AgentsApi.md#start_controllers_power_cycle_nodes) | **POST** /api/v2/controllers/operations/power-cycle-nodes | 
*AgentsApi* | [**start_controllers_reboot_port**](docs/AgentsApi.md#start_controllers_reboot_port) | **POST** /api/v2/controllers/operations/reboot-port | 
*AgentsApi* | [**start_controllers_set_app**](docs/AgentsApi.md#start_controllers_set_app) | **POST** /api/v2/controllers/operations/set-app | 
*AgentsApi* | [**start_controllers_set_node_aggregation**](docs/AgentsApi.md#start_controllers_set_node_aggregation) | **POST** /api/v2/controllers/operations/set-node-aggregation | 
*AgentsApi* | [**start_controllers_set_port_link_state**](docs/AgentsApi.md#start_controllers_set_port_link_state) | **POST** /api/v2/controllers/operations/set-port-link-state | 
*ApplicationResourcesApi* | [**delete_resources_capture**](docs/ApplicationResourcesApi.md#delete_resources_capture) | **DELETE** /api/v2/resources/captures/{captureId} | 
*ApplicationResourcesApi* | [**delete_resources_certificate**](docs/ApplicationResourcesApi.md#delete_resources_certificate) | **DELETE** /api/v2/resources/certificates/{certificateId} | 
*ApplicationResourcesApi* | [**delete_resources_custom_fuzzing_script**](docs/ApplicationResourcesApi.md#delete_resources_custom_fuzzing_script) | **DELETE** /api/v2/resources/custom-fuzzing-scripts/{customFuzzingScriptId} | 
*ApplicationResourcesApi* | [**delete_resources_flow_library**](docs/ApplicationResourcesApi.md#delete_resources_flow_library) | **DELETE** /api/v2/resources/flow-library/{flowLibraryId} | 
*ApplicationResourcesApi* | [**delete_resources_global_playlist**](docs/ApplicationResourcesApi.md#delete_resources_global_playlist) | **DELETE** /api/v2/resources/global-playlists/{globalPlaylistId} | 
*ApplicationResourcesApi* | [**delete_resources_http_library**](docs/ApplicationResourcesApi.md#delete_resources_http_library) | **DELETE** /api/v2/resources/http-library/{httpLibraryId} | 
*ApplicationResourcesApi* | [**delete_resources_media_file**](docs/ApplicationResourcesApi.md#delete_resources_media_file) | **DELETE** /api/v2/resources/media-files/{mediaFileId} | 
*ApplicationResourcesApi* | [**delete_resources_media_library**](docs/ApplicationResourcesApi.md#delete_resources_media_library) | **DELETE** /api/v2/resources/media-library/{mediaLibraryId} | 
*ApplicationResourcesApi* | [**delete_resources_other_library**](docs/ApplicationResourcesApi.md#delete_resources_other_library) | **DELETE** /api/v2/resources/other-library/{otherLibraryId} | 
*ApplicationResourcesApi* | [**delete_resources_payload**](docs/ApplicationResourcesApi.md#delete_resources_payload) | **DELETE** /api/v2/resources/payloads/{payloadId} | 
*ApplicationResourcesApi* | [**delete_resources_pcap**](docs/ApplicationResourcesApi.md#delete_resources_pcap) | **DELETE** /api/v2/resources/pcaps/{pcapId} | 
*ApplicationResourcesApi* | [**delete_resources_playlist**](docs/ApplicationResourcesApi.md#delete_resources_playlist) | **DELETE** /api/v2/resources/playlists/{playlistId} | 
*ApplicationResourcesApi* | [**delete_resources_sip_library**](docs/ApplicationResourcesApi.md#delete_resources_sip_library) | **DELETE** /api/v2/resources/sip-library/{sipLibraryId} | 
*ApplicationResourcesApi* | [**delete_resources_stats_profile**](docs/ApplicationResourcesApi.md#delete_resources_stats_profile) | **DELETE** /api/v2/resources/stats-profile/{statsProfileId} | 
*ApplicationResourcesApi* | [**delete_resources_tls_certificate**](docs/ApplicationResourcesApi.md#delete_resources_tls_certificate) | **DELETE** /api/v2/resources/tls-certificates/{tlsCertificateId} | 
*ApplicationResourcesApi* | [**delete_resources_tls_dh**](docs/ApplicationResourcesApi.md#delete_resources_tls_dh) | **DELETE** /api/v2/resources/tls-dhs/{tlsDhId} | 
*ApplicationResourcesApi* | [**delete_resources_tls_key**](docs/ApplicationResourcesApi.md#delete_resources_tls_key) | **DELETE** /api/v2/resources/tls-keys/{tlsKeyId} | 
*ApplicationResourcesApi* | [**delete_resources_user_defined_app**](docs/ApplicationResourcesApi.md#delete_resources_user_defined_app) | **DELETE** /api/v2/resources/user-defined-apps/{userDefinedAppId} | 
*ApplicationResourcesApi* | [**get_capture_flows**](docs/ApplicationResourcesApi.md#get_capture_flows) | **GET** /api/v2/resources/captures/{captureId}/flows | 
*ApplicationResourcesApi* | [**get_flow_exchanges**](docs/ApplicationResourcesApi.md#get_flow_exchanges) | **GET** /api/v2/resources/captures/{captureId}/flows/{flowId}/exchanges | 
*ApplicationResourcesApi* | [**get_resources_app_by_id**](docs/ApplicationResourcesApi.md#get_resources_app_by_id) | **GET** /api/v2/resources/apps/{appId} | 
*ApplicationResourcesApi* | [**get_resources_application_type_by_id**](docs/ApplicationResourcesApi.md#get_resources_application_type_by_id) | **GET** /api/v2/resources/application-types/{applicationTypeId} | 
*ApplicationResourcesApi* | [**get_resources_application_types**](docs/ApplicationResourcesApi.md#get_resources_application_types) | **GET** /api/v2/resources/application-types | 
*ApplicationResourcesApi* | [**get_resources_apps**](docs/ApplicationResourcesApi.md#get_resources_apps) | **GET** /api/v2/resources/apps | 
*ApplicationResourcesApi* | [**get_resources_attack_by_id**](docs/ApplicationResourcesApi.md#get_resources_attack_by_id) | **GET** /api/v2/resources/attacks/{attackId} | 
*ApplicationResourcesApi* | [**get_resources_attack_categories**](docs/ApplicationResourcesApi.md#get_resources_attack_categories) | **GET** /api/v2/resources/attack-categories | 
*ApplicationResourcesApi* | [**get_resources_attacks**](docs/ApplicationResourcesApi.md#get_resources_attacks) | **GET** /api/v2/resources/attacks | 
*ApplicationResourcesApi* | [**get_resources_auth_profile_by_id**](docs/ApplicationResourcesApi.md#get_resources_auth_profile_by_id) | **GET** /api/v2/resources/auth-profiles/{authProfileId} | 
*ApplicationResourcesApi* | [**get_resources_auth_profiles**](docs/ApplicationResourcesApi.md#get_resources_auth_profiles) | **GET** /api/v2/resources/auth-profiles | 
*ApplicationResourcesApi* | [**get_resources_capture_by_id**](docs/ApplicationResourcesApi.md#get_resources_capture_by_id) | **GET** /api/v2/resources/captures/{captureId} | 
*ApplicationResourcesApi* | [**get_resources_captures**](docs/ApplicationResourcesApi.md#get_resources_captures) | **GET** /api/v2/resources/captures | 
*ApplicationResourcesApi* | [**get_resources_captures_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_captures_upload_file_result) | **GET** /api/v2/resources/captures/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_certificate_by_id**](docs/ApplicationResourcesApi.md#get_resources_certificate_by_id) | **GET** /api/v2/resources/certificates/{certificateId} | 
*ApplicationResourcesApi* | [**get_resources_certificate_content_file**](docs/ApplicationResourcesApi.md#get_resources_certificate_content_file) | **GET** /api/v2/resources/certificates/{certificateId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_certificates**](docs/ApplicationResourcesApi.md#get_resources_certificates) | **GET** /api/v2/resources/certificates | 
*ApplicationResourcesApi* | [**get_resources_certificates_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_certificates_upload_file_result) | **GET** /api/v2/resources/certificates/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_custom_fuzzing_script_by_id**](docs/ApplicationResourcesApi.md#get_resources_custom_fuzzing_script_by_id) | **GET** /api/v2/resources/custom-fuzzing-scripts/{customFuzzingScriptId} | 
*ApplicationResourcesApi* | [**get_resources_custom_fuzzing_script_content_file**](docs/ApplicationResourcesApi.md#get_resources_custom_fuzzing_script_content_file) | **GET** /api/v2/resources/custom-fuzzing-scripts/{customFuzzingScriptId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_custom_fuzzing_scripts**](docs/ApplicationResourcesApi.md#get_resources_custom_fuzzing_scripts) | **GET** /api/v2/resources/custom-fuzzing-scripts | 
*ApplicationResourcesApi* | [**get_resources_custom_fuzzing_scripts_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_custom_fuzzing_scripts_upload_file_result) | **GET** /api/v2/resources/custom-fuzzing-scripts/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_flow_library**](docs/ApplicationResourcesApi.md#get_resources_flow_library) | **GET** /api/v2/resources/flow-library | 
*ApplicationResourcesApi* | [**get_resources_flow_library_by_id**](docs/ApplicationResourcesApi.md#get_resources_flow_library_by_id) | **GET** /api/v2/resources/flow-library/{flowLibraryId} | 
*ApplicationResourcesApi* | [**get_resources_flow_library_content_file**](docs/ApplicationResourcesApi.md#get_resources_flow_library_content_file) | **GET** /api/v2/resources/flow-library/{flowLibraryId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_flow_library_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_flow_library_upload_file_result) | **GET** /api/v2/resources/flow-library/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_global_playlist_by_id**](docs/ApplicationResourcesApi.md#get_resources_global_playlist_by_id) | **GET** /api/v2/resources/global-playlists/{globalPlaylistId} | 
*ApplicationResourcesApi* | [**get_resources_global_playlist_content_file**](docs/ApplicationResourcesApi.md#get_resources_global_playlist_content_file) | **GET** /api/v2/resources/global-playlists/{globalPlaylistId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_global_playlists**](docs/ApplicationResourcesApi.md#get_resources_global_playlists) | **GET** /api/v2/resources/global-playlists | 
*ApplicationResourcesApi* | [**get_resources_global_playlists_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_global_playlists_upload_file_result) | **GET** /api/v2/resources/global-playlists/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_http_library**](docs/ApplicationResourcesApi.md#get_resources_http_library) | **GET** /api/v2/resources/http-library | 
*ApplicationResourcesApi* | [**get_resources_http_library_by_id**](docs/ApplicationResourcesApi.md#get_resources_http_library_by_id) | **GET** /api/v2/resources/http-library/{httpLibraryId} | 
*ApplicationResourcesApi* | [**get_resources_http_library_content_file**](docs/ApplicationResourcesApi.md#get_resources_http_library_content_file) | **GET** /api/v2/resources/http-library/{httpLibraryId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_http_library_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_http_library_upload_file_result) | **GET** /api/v2/resources/http-library/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_http_profile_by_id**](docs/ApplicationResourcesApi.md#get_resources_http_profile_by_id) | **GET** /api/v2/resources/http-profiles/{httpProfileId} | 
*ApplicationResourcesApi* | [**get_resources_http_profiles**](docs/ApplicationResourcesApi.md#get_resources_http_profiles) | **GET** /api/v2/resources/http-profiles | 
*ApplicationResourcesApi* | [**get_resources_media_file_by_id**](docs/ApplicationResourcesApi.md#get_resources_media_file_by_id) | **GET** /api/v2/resources/media-files/{mediaFileId} | 
*ApplicationResourcesApi* | [**get_resources_media_file_content_file**](docs/ApplicationResourcesApi.md#get_resources_media_file_content_file) | **GET** /api/v2/resources/media-files/{mediaFileId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_media_files**](docs/ApplicationResourcesApi.md#get_resources_media_files) | **GET** /api/v2/resources/media-files | 
*ApplicationResourcesApi* | [**get_resources_media_files_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_media_files_upload_file_result) | **GET** /api/v2/resources/media-files/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_media_library**](docs/ApplicationResourcesApi.md#get_resources_media_library) | **GET** /api/v2/resources/media-library | 
*ApplicationResourcesApi* | [**get_resources_media_library_by_id**](docs/ApplicationResourcesApi.md#get_resources_media_library_by_id) | **GET** /api/v2/resources/media-library/{mediaLibraryId} | 
*ApplicationResourcesApi* | [**get_resources_media_library_content_file**](docs/ApplicationResourcesApi.md#get_resources_media_library_content_file) | **GET** /api/v2/resources/media-library/{mediaLibraryId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_media_library_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_media_library_upload_file_result) | **GET** /api/v2/resources/media-library/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_other_library**](docs/ApplicationResourcesApi.md#get_resources_other_library) | **GET** /api/v2/resources/other-library | 
*ApplicationResourcesApi* | [**get_resources_other_library_by_id**](docs/ApplicationResourcesApi.md#get_resources_other_library_by_id) | **GET** /api/v2/resources/other-library/{otherLibraryId} | 
*ApplicationResourcesApi* | [**get_resources_other_library_content_file**](docs/ApplicationResourcesApi.md#get_resources_other_library_content_file) | **GET** /api/v2/resources/other-library/{otherLibraryId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_other_library_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_other_library_upload_file_result) | **GET** /api/v2/resources/other-library/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_payload_by_id**](docs/ApplicationResourcesApi.md#get_resources_payload_by_id) | **GET** /api/v2/resources/payloads/{payloadId} | 
*ApplicationResourcesApi* | [**get_resources_payload_content_file**](docs/ApplicationResourcesApi.md#get_resources_payload_content_file) | **GET** /api/v2/resources/payloads/{payloadId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_payloads**](docs/ApplicationResourcesApi.md#get_resources_payloads) | **GET** /api/v2/resources/payloads | 
*ApplicationResourcesApi* | [**get_resources_payloads_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_payloads_upload_file_result) | **GET** /api/v2/resources/payloads/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_pcap_by_id**](docs/ApplicationResourcesApi.md#get_resources_pcap_by_id) | **GET** /api/v2/resources/pcaps/{pcapId} | 
*ApplicationResourcesApi* | [**get_resources_pcap_content_file**](docs/ApplicationResourcesApi.md#get_resources_pcap_content_file) | **GET** /api/v2/resources/pcaps/{pcapId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_pcaps**](docs/ApplicationResourcesApi.md#get_resources_pcaps) | **GET** /api/v2/resources/pcaps | 
*ApplicationResourcesApi* | [**get_resources_pcaps_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_pcaps_upload_file_result) | **GET** /api/v2/resources/pcaps/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_playlist_by_id**](docs/ApplicationResourcesApi.md#get_resources_playlist_by_id) | **GET** /api/v2/resources/playlists/{playlistId} | 
*ApplicationResourcesApi* | [**get_resources_playlist_content_file**](docs/ApplicationResourcesApi.md#get_resources_playlist_content_file) | **GET** /api/v2/resources/playlists/{playlistId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_playlist_values**](docs/ApplicationResourcesApi.md#get_resources_playlist_values) | **GET** /api/v2/resources/playlists/{playlistId}/values | 
*ApplicationResourcesApi* | [**get_resources_playlists**](docs/ApplicationResourcesApi.md#get_resources_playlists) | **GET** /api/v2/resources/playlists | 
*ApplicationResourcesApi* | [**get_resources_playlists_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_playlists_upload_file_result) | **GET** /api/v2/resources/playlists/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_sip_library**](docs/ApplicationResourcesApi.md#get_resources_sip_library) | **GET** /api/v2/resources/sip-library | 
*ApplicationResourcesApi* | [**get_resources_sip_library_by_id**](docs/ApplicationResourcesApi.md#get_resources_sip_library_by_id) | **GET** /api/v2/resources/sip-library/{sipLibraryId} | 
*ApplicationResourcesApi* | [**get_resources_sip_library_content_file**](docs/ApplicationResourcesApi.md#get_resources_sip_library_content_file) | **GET** /api/v2/resources/sip-library/{sipLibraryId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_sip_library_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_sip_library_upload_file_result) | **GET** /api/v2/resources/sip-library/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_stats_profile**](docs/ApplicationResourcesApi.md#get_resources_stats_profile) | **GET** /api/v2/resources/stats-profile | 
*ApplicationResourcesApi* | [**get_resources_stats_profile_by_id**](docs/ApplicationResourcesApi.md#get_resources_stats_profile_by_id) | **GET** /api/v2/resources/stats-profile/{statsProfileId} | 
*ApplicationResourcesApi* | [**get_resources_stats_profile_content_file**](docs/ApplicationResourcesApi.md#get_resources_stats_profile_content_file) | **GET** /api/v2/resources/stats-profile/{statsProfileId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_stats_profile_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_stats_profile_upload_file_result) | **GET** /api/v2/resources/stats-profile/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_strike_by_id**](docs/ApplicationResourcesApi.md#get_resources_strike_by_id) | **GET** /api/v2/resources/strikes/{strikeId} | 
*ApplicationResourcesApi* | [**get_resources_strike_categories**](docs/ApplicationResourcesApi.md#get_resources_strike_categories) | **GET** /api/v2/resources/strike-categories | 
*ApplicationResourcesApi* | [**get_resources_strikes**](docs/ApplicationResourcesApi.md#get_resources_strikes) | **GET** /api/v2/resources/strikes | 
*ApplicationResourcesApi* | [**get_resources_tls_certificate_by_id**](docs/ApplicationResourcesApi.md#get_resources_tls_certificate_by_id) | **GET** /api/v2/resources/tls-certificates/{tlsCertificateId} | 
*ApplicationResourcesApi* | [**get_resources_tls_certificate_content_file**](docs/ApplicationResourcesApi.md#get_resources_tls_certificate_content_file) | **GET** /api/v2/resources/tls-certificates/{tlsCertificateId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_tls_certificates**](docs/ApplicationResourcesApi.md#get_resources_tls_certificates) | **GET** /api/v2/resources/tls-certificates | 
*ApplicationResourcesApi* | [**get_resources_tls_certificates_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_tls_certificates_upload_file_result) | **GET** /api/v2/resources/tls-certificates/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_tls_dh_by_id**](docs/ApplicationResourcesApi.md#get_resources_tls_dh_by_id) | **GET** /api/v2/resources/tls-dhs/{tlsDhId} | 
*ApplicationResourcesApi* | [**get_resources_tls_dh_content_file**](docs/ApplicationResourcesApi.md#get_resources_tls_dh_content_file) | **GET** /api/v2/resources/tls-dhs/{tlsDhId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_tls_dhs**](docs/ApplicationResourcesApi.md#get_resources_tls_dhs) | **GET** /api/v2/resources/tls-dhs | 
*ApplicationResourcesApi* | [**get_resources_tls_dhs_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_tls_dhs_upload_file_result) | **GET** /api/v2/resources/tls-dhs/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_tls_key_by_id**](docs/ApplicationResourcesApi.md#get_resources_tls_key_by_id) | **GET** /api/v2/resources/tls-keys/{tlsKeyId} | 
*ApplicationResourcesApi* | [**get_resources_tls_key_content_file**](docs/ApplicationResourcesApi.md#get_resources_tls_key_content_file) | **GET** /api/v2/resources/tls-keys/{tlsKeyId}/contentFile | 
*ApplicationResourcesApi* | [**get_resources_tls_keys**](docs/ApplicationResourcesApi.md#get_resources_tls_keys) | **GET** /api/v2/resources/tls-keys | 
*ApplicationResourcesApi* | [**get_resources_tls_keys_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_tls_keys_upload_file_result) | **GET** /api/v2/resources/tls-keys/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**get_resources_user_defined_apps**](docs/ApplicationResourcesApi.md#get_resources_user_defined_apps) | **GET** /api/v2/resources/user-defined-apps | 
*ApplicationResourcesApi* | [**get_resources_user_defined_apps_upload_file_result**](docs/ApplicationResourcesApi.md#get_resources_user_defined_apps_upload_file_result) | **GET** /api/v2/resources/user-defined-apps/operations/uploadFile/{uploadFileId}/result | 
*ApplicationResourcesApi* | [**poll_resources_apps_export_all**](docs/ApplicationResourcesApi.md#poll_resources_apps_export_all) | **GET** /api/v2/resources/apps/operations/export-all/{id} | 
*ApplicationResourcesApi* | [**poll_resources_captures_batch_delete**](docs/ApplicationResourcesApi.md#poll_resources_captures_batch_delete) | **GET** /api/v2/resources/captures/operations/batch-delete/{id} | 
*ApplicationResourcesApi* | [**poll_resources_captures_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_captures_upload_file) | **GET** /api/v2/resources/captures/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_certificates_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_certificates_upload_file) | **GET** /api/v2/resources/certificates/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_config_export_user_defined_apps**](docs/ApplicationResourcesApi.md#poll_resources_config_export_user_defined_apps) | **GET** /api/v2/resources/configs/{configId}/operations/export-user-defined-apps/{id} | 
*ApplicationResourcesApi* | [**poll_resources_create_app**](docs/ApplicationResourcesApi.md#poll_resources_create_app) | **GET** /api/v2/resources/operations/create-app/{id} | 
*ApplicationResourcesApi* | [**poll_resources_custom_fuzzing_scripts_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_custom_fuzzing_scripts_upload_file) | **GET** /api/v2/resources/custom-fuzzing-scripts/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_edit_app**](docs/ApplicationResourcesApi.md#poll_resources_edit_app) | **GET** /api/v2/resources/operations/edit-app/{id} | 
*ApplicationResourcesApi* | [**poll_resources_find_param_matches**](docs/ApplicationResourcesApi.md#poll_resources_find_param_matches) | **GET** /api/v2/resources/operations/find-param-matches/{id} | 
*ApplicationResourcesApi* | [**poll_resources_flow_library_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_flow_library_upload_file) | **GET** /api/v2/resources/flow-library/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_get_attack_categories**](docs/ApplicationResourcesApi.md#poll_resources_get_attack_categories) | **GET** /api/v2/resources/operations/get-attack-categories/{id} | 
*ApplicationResourcesApi* | [**poll_resources_get_attacks**](docs/ApplicationResourcesApi.md#poll_resources_get_attacks) | **GET** /api/v2/resources/operations/get-attacks/{id} | 
*ApplicationResourcesApi* | [**poll_resources_get_strike_categories**](docs/ApplicationResourcesApi.md#poll_resources_get_strike_categories) | **GET** /api/v2/resources/operations/get-strike-categories/{id} | 
*ApplicationResourcesApi* | [**poll_resources_get_strikes**](docs/ApplicationResourcesApi.md#poll_resources_get_strikes) | **GET** /api/v2/resources/operations/get-strikes/{id} | 
*ApplicationResourcesApi* | [**poll_resources_global_playlists_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_global_playlists_upload_file) | **GET** /api/v2/resources/global-playlists/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_http_library_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_http_library_upload_file) | **GET** /api/v2/resources/http-library/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_media_files_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_media_files_upload_file) | **GET** /api/v2/resources/media-files/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_media_library_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_media_library_upload_file) | **GET** /api/v2/resources/media-library/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_other_library_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_other_library_upload_file) | **GET** /api/v2/resources/other-library/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_payloads_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_payloads_upload_file) | **GET** /api/v2/resources/payloads/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_pcaps_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_pcaps_upload_file) | **GET** /api/v2/resources/pcaps/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_playlists_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_playlists_upload_file) | **GET** /api/v2/resources/playlists/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_sip_library_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_sip_library_upload_file) | **GET** /api/v2/resources/sip-library/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_stats_profile_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_stats_profile_upload_file) | **GET** /api/v2/resources/stats-profile/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_tls_certificates_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_tls_certificates_upload_file) | **GET** /api/v2/resources/tls-certificates/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_tls_dhs_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_tls_dhs_upload_file) | **GET** /api/v2/resources/tls-dhs/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_tls_keys_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_tls_keys_upload_file) | **GET** /api/v2/resources/tls-keys/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**poll_resources_user_defined_apps_export_all**](docs/ApplicationResourcesApi.md#poll_resources_user_defined_apps_export_all) | **GET** /api/v2/resources/user-defined-apps/operations/export-all/{id} | 
*ApplicationResourcesApi* | [**poll_resources_user_defined_apps_upload_file**](docs/ApplicationResourcesApi.md#poll_resources_user_defined_apps_upload_file) | **GET** /api/v2/resources/user-defined-apps/operations/uploadFile/{uploadFileId} | 
*ApplicationResourcesApi* | [**start_resources_apps_export_all**](docs/ApplicationResourcesApi.md#start_resources_apps_export_all) | **POST** /api/v2/resources/apps/operations/export-all | 
*ApplicationResourcesApi* | [**start_resources_captures_batch_delete**](docs/ApplicationResourcesApi.md#start_resources_captures_batch_delete) | **POST** /api/v2/resources/captures/operations/batch-delete | 
*ApplicationResourcesApi* | [**start_resources_captures_upload_file**](docs/ApplicationResourcesApi.md#start_resources_captures_upload_file) | **POST** /api/v2/resources/captures/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_certificates_upload_file**](docs/ApplicationResourcesApi.md#start_resources_certificates_upload_file) | **POST** /api/v2/resources/certificates/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_config_export_user_defined_apps**](docs/ApplicationResourcesApi.md#start_resources_config_export_user_defined_apps) | **POST** /api/v2/resources/configs/{configId}/operations/export-user-defined-apps | 
*ApplicationResourcesApi* | [**start_resources_create_app**](docs/ApplicationResourcesApi.md#start_resources_create_app) | **POST** /api/v2/resources/operations/create-app | 
*ApplicationResourcesApi* | [**start_resources_custom_fuzzing_scripts_upload_file**](docs/ApplicationResourcesApi.md#start_resources_custom_fuzzing_scripts_upload_file) | **POST** /api/v2/resources/custom-fuzzing-scripts/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_edit_app**](docs/ApplicationResourcesApi.md#start_resources_edit_app) | **POST** /api/v2/resources/operations/edit-app | 
*ApplicationResourcesApi* | [**start_resources_find_param_matches**](docs/ApplicationResourcesApi.md#start_resources_find_param_matches) | **POST** /api/v2/resources/operations/find-param-matches | 
*ApplicationResourcesApi* | [**start_resources_flow_library_upload_file**](docs/ApplicationResourcesApi.md#start_resources_flow_library_upload_file) | **POST** /api/v2/resources/flow-library/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_get_attack_categories**](docs/ApplicationResourcesApi.md#start_resources_get_attack_categories) | **POST** /api/v2/resources/operations/get-attack-categories | 
*ApplicationResourcesApi* | [**start_resources_get_attacks**](docs/ApplicationResourcesApi.md#start_resources_get_attacks) | **POST** /api/v2/resources/operations/get-attacks | 
*ApplicationResourcesApi* | [**start_resources_get_strike_categories**](docs/ApplicationResourcesApi.md#start_resources_get_strike_categories) | **POST** /api/v2/resources/operations/get-strike-categories | 
*ApplicationResourcesApi* | [**start_resources_get_strikes**](docs/ApplicationResourcesApi.md#start_resources_get_strikes) | **POST** /api/v2/resources/operations/get-strikes | 
*ApplicationResourcesApi* | [**start_resources_global_playlists_upload_file**](docs/ApplicationResourcesApi.md#start_resources_global_playlists_upload_file) | **POST** /api/v2/resources/global-playlists/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_http_library_upload_file**](docs/ApplicationResourcesApi.md#start_resources_http_library_upload_file) | **POST** /api/v2/resources/http-library/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_media_files_upload_file**](docs/ApplicationResourcesApi.md#start_resources_media_files_upload_file) | **POST** /api/v2/resources/media-files/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_media_library_upload_file**](docs/ApplicationResourcesApi.md#start_resources_media_library_upload_file) | **POST** /api/v2/resources/media-library/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_other_library_upload_file**](docs/ApplicationResourcesApi.md#start_resources_other_library_upload_file) | **POST** /api/v2/resources/other-library/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_payloads_upload_file**](docs/ApplicationResourcesApi.md#start_resources_payloads_upload_file) | **POST** /api/v2/resources/payloads/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_pcaps_upload_file**](docs/ApplicationResourcesApi.md#start_resources_pcaps_upload_file) | **POST** /api/v2/resources/pcaps/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_playlists_upload_file**](docs/ApplicationResourcesApi.md#start_resources_playlists_upload_file) | **POST** /api/v2/resources/playlists/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_sip_library_upload_file**](docs/ApplicationResourcesApi.md#start_resources_sip_library_upload_file) | **POST** /api/v2/resources/sip-library/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_stats_profile_upload_file**](docs/ApplicationResourcesApi.md#start_resources_stats_profile_upload_file) | **POST** /api/v2/resources/stats-profile/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_tls_certificates_upload_file**](docs/ApplicationResourcesApi.md#start_resources_tls_certificates_upload_file) | **POST** /api/v2/resources/tls-certificates/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_tls_dhs_upload_file**](docs/ApplicationResourcesApi.md#start_resources_tls_dhs_upload_file) | **POST** /api/v2/resources/tls-dhs/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_tls_keys_upload_file**](docs/ApplicationResourcesApi.md#start_resources_tls_keys_upload_file) | **POST** /api/v2/resources/tls-keys/operations/uploadFile | 
*ApplicationResourcesApi* | [**start_resources_user_defined_apps_export_all**](docs/ApplicationResourcesApi.md#start_resources_user_defined_apps_export_all) | **POST** /api/v2/resources/user-defined-apps/operations/export-all | 
*ApplicationResourcesApi* | [**start_resources_user_defined_apps_upload_file**](docs/ApplicationResourcesApi.md#start_resources_user_defined_apps_upload_file) | **POST** /api/v2/resources/user-defined-apps/operations/uploadFile | 
*AuthorizationApi* | [**authenticate**](docs/AuthorizationApi.md#authenticate) | **POST** /auth/realms/keysight/protocol/openid-connect/token | 
*BrokersApi* | [**create_brokers**](docs/BrokersApi.md#create_brokers) | **POST** /api/v2/brokers | 
*BrokersApi* | [**delete_broker**](docs/BrokersApi.md#delete_broker) | **DELETE** /api/v2/brokers/{brokerId} | 
*BrokersApi* | [**get_broker_by_id**](docs/BrokersApi.md#get_broker_by_id) | **GET** /api/v2/brokers/{brokerId} | 
*BrokersApi* | [**get_brokers**](docs/BrokersApi.md#get_brokers) | **GET** /api/v2/brokers | 
*BrokersApi* | [**patch_broker**](docs/BrokersApi.md#patch_broker) | **PATCH** /api/v2/brokers/{brokerId} | 
*ConfigurationsApi* | [**create_configs**](docs/ConfigurationsApi.md#create_configs) | **POST** /api/v2/configs | 
*ConfigurationsApi* | [**delete_config**](docs/ConfigurationsApi.md#delete_config) | **DELETE** /api/v2/configs/{configId} | 
*ConfigurationsApi* | [**get_config_by_id**](docs/ConfigurationsApi.md#get_config_by_id) | **GET** /api/v2/configs/{configId} | 
*ConfigurationsApi* | [**get_config_categories**](docs/ConfigurationsApi.md#get_config_categories) | **GET** /api/v2/config-categories | 
*ConfigurationsApi* | [**get_configs**](docs/ConfigurationsApi.md#get_configs) | **GET** /api/v2/configs | 
*ConfigurationsApi* | [**get_resources_custom_import_operations**](docs/ConfigurationsApi.md#get_resources_custom_import_operations) | **GET** /api/v2/resources/custom-import-operations | 
*ConfigurationsApi* | [**patch_config**](docs/ConfigurationsApi.md#patch_config) | **PATCH** /api/v2/configs/{configId} | 
*ConfigurationsApi* | [**poll_configs_batch_delete**](docs/ConfigurationsApi.md#poll_configs_batch_delete) | **GET** /api/v2/configs/operations/batch-delete/{id} | 
*ConfigurationsApi* | [**poll_configs_export_all**](docs/ConfigurationsApi.md#poll_configs_export_all) | **GET** /api/v2/configs/operations/exportAll/{id} | 
*ConfigurationsApi* | [**poll_configs_import**](docs/ConfigurationsApi.md#poll_configs_import) | **GET** /api/v2/configs/operations/import/{id} | 
*ConfigurationsApi* | [**poll_configs_import_all**](docs/ConfigurationsApi.md#poll_configs_import_all) | **GET** /api/v2/configs/operations/importAll/{id} | 
*ConfigurationsApi* | [**start_configs_batch_delete**](docs/ConfigurationsApi.md#start_configs_batch_delete) | **POST** /api/v2/configs/operations/batch-delete | 
*ConfigurationsApi* | [**start_configs_export_all**](docs/ConfigurationsApi.md#start_configs_export_all) | **POST** /api/v2/configs/operations/exportAll | 
*ConfigurationsApi* | [**start_configs_import**](docs/ConfigurationsApi.md#start_configs_import) | **POST** /api/v2/configs/operations/import | 
*ConfigurationsApi* | [**start_configs_import_all**](docs/ConfigurationsApi.md#start_configs_import_all) | **POST** /api/v2/configs/operations/importAll | 
*ConfigurationsApi* | [**update_config**](docs/ConfigurationsApi.md#update_config) | **PUT** /api/v2/configs/{configId} | 
*DataMigrationApi* | [**poll_controller_migration_export**](docs/DataMigrationApi.md#poll_controller_migration_export) | **GET** /api/v2/controller-migration/operations/export/{id} | 
*DataMigrationApi* | [**poll_controller_migration_import**](docs/DataMigrationApi.md#poll_controller_migration_import) | **GET** /api/v2/controller-migration/operations/import/{id} | 
*DataMigrationApi* | [**start_controller_migration_export**](docs/DataMigrationApi.md#start_controller_migration_export) | **POST** /api/v2/controller-migration/operations/export | 
*DataMigrationApi* | [**start_controller_migration_import**](docs/DataMigrationApi.md#start_controller_migration_import) | **POST** /api/v2/controller-migration/operations/import | 
*DiagnosticsApi* | [**api_v2_diagnostics_components_get**](docs/DiagnosticsApi.md#api_v2_diagnostics_components_get) | **GET** /api/v2/diagnostics/components | 
*DiagnosticsApi* | [**api_v2_diagnostics_operations_delete_delete**](docs/DiagnosticsApi.md#api_v2_diagnostics_operations_delete_delete) | **DELETE** /api/v2/diagnostics/operations/delete | 
*DiagnosticsApi* | [**api_v2_diagnostics_operations_delete_id_delete**](docs/DiagnosticsApi.md#api_v2_diagnostics_operations_delete_id_delete) | **DELETE** /api/v2/diagnostics/operations/delete/{id} | 
*DiagnosticsApi* | [**api_v2_diagnostics_operations_export_get**](docs/DiagnosticsApi.md#api_v2_diagnostics_operations_export_get) | **GET** /api/v2/diagnostics/operations/export | 
*DiagnosticsApi* | [**api_v2_diagnostics_operations_export_id_get**](docs/DiagnosticsApi.md#api_v2_diagnostics_operations_export_id_get) | **GET** /api/v2/diagnostics/operations/export/{id} | 
*DiagnosticsApi* | [**api_v2_diagnostics_operations_export_id_result_get**](docs/DiagnosticsApi.md#api_v2_diagnostics_operations_export_id_result_get) | **GET** /api/v2/diagnostics/operations/export/{id}/result | 
*DiagnosticsApi* | [**api_v2_diagnostics_operations_export_post**](docs/DiagnosticsApi.md#api_v2_diagnostics_operations_export_post) | **POST** /api/v2/diagnostics/operations/export | 
*LicenseServersApi* | [**create_license_servers**](docs/LicenseServersApi.md#create_license_servers) | **POST** /api/v2/license-servers | 
*LicenseServersApi* | [**delete_license_server**](docs/LicenseServersApi.md#delete_license_server) | **DELETE** /api/v2/license-servers/{licenseServerId} | 
*LicenseServersApi* | [**get_license_server_by_id**](docs/LicenseServersApi.md#get_license_server_by_id) | **GET** /api/v2/license-servers/{licenseServerId} | 
*LicenseServersApi* | [**get_license_servers**](docs/LicenseServersApi.md#get_license_servers) | **GET** /api/v2/license-servers | 
*LicenseServersApi* | [**patch_license_server**](docs/LicenseServersApi.md#patch_license_server) | **PATCH** /api/v2/license-servers/{licenseServerId} | 
*LicensingApi* | [**activate_licenses**](docs/LicensingApi.md#activate_licenses) | **POST** /api/v2/licensing/operations/activate | Performs an online request to KSM and activates the requested licenses.
*LicensingApi* | [**deactivate_licenses**](docs/LicensingApi.md#deactivate_licenses) | **POST** /api/v2/licensing/operations/deactivate | Performs an online request to KSM to deactivate the requested licenses.
*LicensingApi* | [**generate_offline_request**](docs/LicensingApi.md#generate_offline_request) | **GET** /api/v2/licensing/generate-offline-request | Generates an offline request that can be used on the offline licensing portal.
*LicensingApi* | [**get_activation_code_info**](docs/LicensingApi.md#get_activation_code_info) | **POST** /api/v2/licensing/operations/retrieve-activation-code-info | Retrieves the activation code info from KSM.
*LicensingApi* | [**get_activation_code_info_list**](docs/LicensingApi.md#get_activation_code_info_list) | **POST** /api/v2/licensing/operations/retrieve-activation-code-info-list | Retrieves the activation code info list from KSM.
*LicensingApi* | [**get_async_operation_result**](docs/LicensingApi.md#get_async_operation_result) | **GET** /api/v2/licensing/operations/{operationType}/{id}/result | Returns the result of async operation.
*LicensingApi* | [**get_async_operation_status**](docs/LicensingApi.md#get_async_operation_status) | **GET** /api/v2/licensing/operations/{operationType}/{id} | Returns the status of an ongoing async operation.
*LicensingApi* | [**get_counted_feature_stats**](docs/LicensingApi.md#get_counted_feature_stats) | **POST** /api/v2/licensing/operations/retrieve-counted-feature-stats | Retrieves the counted feature stats.
*LicensingApi* | [**get_entitlement_code_info**](docs/LicensingApi.md#get_entitlement_code_info) | **POST** /api/v2/licensing/operations/retrieve-entitlement-code-info | Retrieves the activations codes of the supplied entitlement code from KSM.
*LicensingApi* | [**get_hostid**](docs/LicensingApi.md#get_hostid) | **GET** /api/v2/licensing/hostid | Retrieves the host ID of the license server.
*LicensingApi* | [**get_installed_licenses**](docs/LicensingApi.md#get_installed_licenses) | **GET** /api/v2/licensing/licenses | Returns the installed licenses.
*LicensingApi* | [**get_license**](docs/LicensingApi.md#get_license) | **GET** /api/v2/licensing/licenses/{licenseId} | Returns the requested license.
*LicensingApi* | [**get_license_async_operation_result**](docs/LicensingApi.md#get_license_async_operation_result) | **GET** /api/v2/licensing/licenses/{licenseId}/operations/{operationType}/{id}/result | Returns the result of async operation.
*LicensingApi* | [**get_license_async_operation_status**](docs/LicensingApi.md#get_license_async_operation_status) | **GET** /api/v2/licensing/licenses/{licenseId}/operations/{operationType}/{id} | Returns the status of an ongoing async operation. 
*LicensingApi* | [**import_offline_license**](docs/LicensingApi.md#import_offline_license) | **POST** /api/v2/licensing/import-offline-license | Installs the offline license.
*LicensingApi* | [**remove_reservation**](docs/LicensingApi.md#remove_reservation) | **POST** /api/v2/licensing/licenses/{licenseId}/operations/reservation-remove | Remove previously reserved features, thus making them available for checkout by other users. 
*LicensingApi* | [**sync_licenses**](docs/LicensingApi.md#sync_licenses) | **POST** /api/v2/licensing/operations/synchronize-licenses | Synchronize local licenses with KSM.
*LicensingApi* | [**test_backend_connectivity**](docs/LicensingApi.md#test_backend_connectivity) | **POST** /api/v2/licensing/operations/test-backend-connectivity | Tests connection of the license server with KSM.
*LicensingApi* | [**update_reservation**](docs/LicensingApi.md#update_reservation) | **POST** /api/v2/licensing/licenses/{licenseId}/operations/reservation-reserve | Retain over a period of time specific counts of installed features, that can be consumed only by current user. 
*NotificationsApi* | [**delete_notification**](docs/NotificationsApi.md#delete_notification) | **DELETE** /api/v2/notifications/{notificationId} | 
*NotificationsApi* | [**get_notification_by_id**](docs/NotificationsApi.md#get_notification_by_id) | **GET** /api/v2/notifications/{notificationId} | 
*NotificationsApi* | [**get_notification_counts**](docs/NotificationsApi.md#get_notification_counts) | **GET** /api/v2/notification-counts | 
*NotificationsApi* | [**get_notifications**](docs/NotificationsApi.md#get_notifications) | **GET** /api/v2/notifications | 
*NotificationsApi* | [**poll_notifications_cleanup**](docs/NotificationsApi.md#poll_notifications_cleanup) | **GET** /api/v2/notifications/operations/cleanup/{id} | 
*NotificationsApi* | [**poll_notifications_dismiss**](docs/NotificationsApi.md#poll_notifications_dismiss) | **GET** /api/v2/notifications/operations/dismiss/{id} | 
*NotificationsApi* | [**start_notifications_cleanup**](docs/NotificationsApi.md#start_notifications_cleanup) | **POST** /api/v2/notifications/operations/cleanup | 
*NotificationsApi* | [**start_notifications_dismiss**](docs/NotificationsApi.md#start_notifications_dismiss) | **POST** /api/v2/notifications/operations/dismiss | 
*ReportsApi* | [**download_pdf**](docs/ReportsApi.md#download_pdf) | **GET** /api/v2/results/{resultId}/download-pdf/{pdfId} | 
*ReportsApi* | [**get_result_download_csv_by_id**](docs/ReportsApi.md#get_result_download_csv_by_id) | **GET** /api/v2/results/{resultId}/download-csv/{downloadCsvId} | 
*ReportsApi* | [**poll_result_generate_csv**](docs/ReportsApi.md#poll_result_generate_csv) | **GET** /api/v2/results/{resultId}/operations/generate-csv/{id} | 
*ReportsApi* | [**poll_result_generate_pdf**](docs/ReportsApi.md#poll_result_generate_pdf) | **GET** /api/v2/results/{resultId}/operations/generate-pdf/{id} | 
*ReportsApi* | [**start_result_generate_csv**](docs/ReportsApi.md#start_result_generate_csv) | **POST** /api/v2/results/{resultId}/operations/generate-csv | 
*ReportsApi* | [**start_result_generate_pdf**](docs/ReportsApi.md#start_result_generate_pdf) | **POST** /api/v2/results/{resultId}/operations/generate-pdf | 
*SessionsApi* | [**create_session_meta**](docs/SessionsApi.md#create_session_meta) | **POST** /api/v2/sessions/{sessionId}/meta | 
*SessionsApi* | [**create_sessions**](docs/SessionsApi.md#create_sessions) | **POST** /api/v2/sessions | 
*SessionsApi* | [**delete_session**](docs/SessionsApi.md#delete_session) | **DELETE** /api/v2/sessions/{sessionId} | 
*SessionsApi* | [**delete_session_meta**](docs/SessionsApi.md#delete_session_meta) | **DELETE** /api/v2/sessions/{sessionId}/meta/{metaId} | 
*SessionsApi* | [**get_config_docs**](docs/SessionsApi.md#get_config_docs) | **GET** /api/v2/sessions/{sessionId}/config/$docs | 
*SessionsApi* | [**get_config_granular_stats**](docs/SessionsApi.md#get_config_granular_stats) | **GET** /api/v2/sessions/{sessionId}/config/granular-stats | 
*SessionsApi* | [**get_config_granular_stats_filters**](docs/SessionsApi.md#get_config_granular_stats_filters) | **GET** /api/v2/sessions/{sessionId}/config/granular-stats-filters | 
*SessionsApi* | [**get_session_by_id**](docs/SessionsApi.md#get_session_by_id) | **GET** /api/v2/sessions/{sessionId} | 
*SessionsApi* | [**get_session_config**](docs/SessionsApi.md#get_session_config) | **GET** /api/v2/sessions/{sessionId}/config | 
*SessionsApi* | [**get_session_meta**](docs/SessionsApi.md#get_session_meta) | **GET** /api/v2/sessions/{sessionId}/meta | 
*SessionsApi* | [**get_session_meta_by_id**](docs/SessionsApi.md#get_session_meta_by_id) | **GET** /api/v2/sessions/{sessionId}/meta/{metaId} | 
*SessionsApi* | [**get_session_test**](docs/SessionsApi.md#get_session_test) | **GET** /api/v2/sessions/{sessionId}/test | 
*SessionsApi* | [**get_sessions**](docs/SessionsApi.md#get_sessions) | **GET** /api/v2/sessions | 
*SessionsApi* | [**patch_session**](docs/SessionsApi.md#patch_session) | **PATCH** /api/v2/sessions/{sessionId} | 
*SessionsApi* | [**patch_session_meta**](docs/SessionsApi.md#patch_session_meta) | **PATCH** /api/v2/sessions/{sessionId}/meta/{metaId} | 
*SessionsApi* | [**patch_session_test**](docs/SessionsApi.md#patch_session_test) | **PATCH** /api/v2/sessions/{sessionId}/test | 
*SessionsApi* | [**poll_config_add_applications**](docs/SessionsApi.md#poll_config_add_applications) | **GET** /api/v2/sessions/{sessionId}/config/config/TrafficProfiles/{trafficProfileId}/operations/add-applications/{id} | 
*SessionsApi* | [**poll_session_config_granular_stats_default_dashboards**](docs/SessionsApi.md#poll_session_config_granular_stats_default_dashboards) | **GET** /api/v2/sessions/{sessionId}/config/operations/granular-stats-default-dashboards/{id} | 
*SessionsApi* | [**poll_session_config_save**](docs/SessionsApi.md#poll_session_config_save) | **GET** /api/v2/sessions/{sessionId}/config/operations/save/{id} | 
*SessionsApi* | [**poll_session_load_config**](docs/SessionsApi.md#poll_session_load_config) | **GET** /api/v2/sessions/{sessionId}/operations/loadConfig/{id} | 
*SessionsApi* | [**poll_session_prepare_test**](docs/SessionsApi.md#poll_session_prepare_test) | **GET** /api/v2/sessions/{sessionId}/operations/prepareTest/{id} | 
*SessionsApi* | [**poll_session_test_end**](docs/SessionsApi.md#poll_session_test_end) | **GET** /api/v2/sessions/{sessionId}/operations/testEnd/{id} | 
*SessionsApi* | [**poll_session_test_init**](docs/SessionsApi.md#poll_session_test_init) | **GET** /api/v2/sessions/{sessionId}/operations/testInit/{id} | 
*SessionsApi* | [**poll_session_touch**](docs/SessionsApi.md#poll_session_touch) | **GET** /api/v2/sessions/{sessionId}/operations/touch/{id} | 
*SessionsApi* | [**poll_sessions_batch_delete**](docs/SessionsApi.md#poll_sessions_batch_delete) | **GET** /api/v2/sessions/operations/batch-delete/{id} | 
*SessionsApi* | [**start_config_add_applications**](docs/SessionsApi.md#start_config_add_applications) | **POST** /api/v2/sessions/{sessionId}/config/config/TrafficProfiles/{trafficProfileId}/operations/add-applications | 
*SessionsApi* | [**start_session_config_granular_stats_default_dashboards**](docs/SessionsApi.md#start_session_config_granular_stats_default_dashboards) | **POST** /api/v2/sessions/{sessionId}/config/operations/granular-stats-default-dashboards | 
*SessionsApi* | [**start_session_config_save**](docs/SessionsApi.md#start_session_config_save) | **POST** /api/v2/sessions/{sessionId}/config/operations/save | 
*SessionsApi* | [**start_session_load_config**](docs/SessionsApi.md#start_session_load_config) | **POST** /api/v2/sessions/{sessionId}/operations/loadConfig | 
*SessionsApi* | [**start_session_prepare_test**](docs/SessionsApi.md#start_session_prepare_test) | **POST** /api/v2/sessions/{sessionId}/operations/prepareTest | 
*SessionsApi* | [**start_session_test_end**](docs/SessionsApi.md#start_session_test_end) | **POST** /api/v2/sessions/{sessionId}/operations/testEnd | 
*SessionsApi* | [**start_session_test_init**](docs/SessionsApi.md#start_session_test_init) | **POST** /api/v2/sessions/{sessionId}/operations/testInit | 
*SessionsApi* | [**start_session_touch**](docs/SessionsApi.md#start_session_touch) | **POST** /api/v2/sessions/{sessionId}/operations/touch | 
*SessionsApi* | [**start_sessions_batch_delete**](docs/SessionsApi.md#start_sessions_batch_delete) | **POST** /api/v2/sessions/operations/batch-delete | 
*SessionsApi* | [**update_session**](docs/SessionsApi.md#update_session) | **PUT** /api/v2/sessions/{sessionId} | 
*SessionsApi* | [**update_session_config**](docs/SessionsApi.md#update_session_config) | **PUT** /api/v2/sessions/{sessionId}/config | 
*SessionsApi* | [**update_session_meta**](docs/SessionsApi.md#update_session_meta) | **PUT** /api/v2/sessions/{sessionId}/meta | 
*SessionsApi* | [**update_session_test**](docs/SessionsApi.md#update_session_test) | **PUT** /api/v2/sessions/{sessionId}/test | 
*StatisticsApi* | [**create_stats_plugins**](docs/StatisticsApi.md#create_stats_plugins) | **POST** /api/v2/stats/plugins | 
*StatisticsApi* | [**delete_stats_plugin**](docs/StatisticsApi.md#delete_stats_plugin) | **DELETE** /api/v2/stats/plugins/{pluginId} | 
*StatisticsApi* | [**get_result_stat_by_id**](docs/StatisticsApi.md#get_result_stat_by_id) | **GET** /api/v2/results/{resultId}/stats/{statId} | 
*StatisticsApi* | [**get_result_stats**](docs/StatisticsApi.md#get_result_stats) | **GET** /api/v2/results/{resultId}/stats | 
*StatisticsApi* | [**get_stats_plugins**](docs/StatisticsApi.md#get_stats_plugins) | **GET** /api/v2/stats/plugins | 
*StatisticsApi* | [**poll_stats_plugins_ingest**](docs/StatisticsApi.md#poll_stats_plugins_ingest) | **GET** /api/v2/stats/plugins/operations/ingest/{id} | 
*StatisticsApi* | [**start_stats_plugins_ingest**](docs/StatisticsApi.md#start_stats_plugins_ingest) | **POST** /api/v2/stats/plugins/operations/ingest | 
*TestOperationsApi* | [**poll_test_calibrate_start**](docs/TestOperationsApi.md#poll_test_calibrate_start) | **GET** /api/v2/sessions/{sessionId}/test-calibrate/operations/start/{id} | 
*TestOperationsApi* | [**poll_test_calibrate_stop**](docs/TestOperationsApi.md#poll_test_calibrate_stop) | **GET** /api/v2/sessions/{sessionId}/test-calibrate/operations/stop/{id} | 
*TestOperationsApi* | [**poll_test_run_abort**](docs/TestOperationsApi.md#poll_test_run_abort) | **GET** /api/v2/sessions/{sessionId}/test-run/operations/abort/{id} | 
*TestOperationsApi* | [**poll_test_run_start**](docs/TestOperationsApi.md#poll_test_run_start) | **GET** /api/v2/sessions/{sessionId}/test-run/operations/start/{id} | 
*TestOperationsApi* | [**poll_test_run_stop**](docs/TestOperationsApi.md#poll_test_run_stop) | **GET** /api/v2/sessions/{sessionId}/test-run/operations/stop/{id} | 
*TestOperationsApi* | [**start_test_calibrate_start**](docs/TestOperationsApi.md#start_test_calibrate_start) | **POST** /api/v2/sessions/{sessionId}/test-calibrate/operations/start | 
*TestOperationsApi* | [**start_test_calibrate_stop**](docs/TestOperationsApi.md#start_test_calibrate_stop) | **POST** /api/v2/sessions/{sessionId}/test-calibrate/operations/stop | 
*TestOperationsApi* | [**start_test_run_abort**](docs/TestOperationsApi.md#start_test_run_abort) | **POST** /api/v2/sessions/{sessionId}/test-run/operations/abort | 
*TestOperationsApi* | [**start_test_run_start**](docs/TestOperationsApi.md#start_test_run_start) | **POST** /api/v2/sessions/{sessionId}/test-run/operations/start | 
*TestOperationsApi* | [**start_test_run_stop**](docs/TestOperationsApi.md#start_test_run_stop) | **POST** /api/v2/sessions/{sessionId}/test-run/operations/stop | 
*TestResultsApi* | [**delete_result**](docs/TestResultsApi.md#delete_result) | **DELETE** /api/v2/results/{resultId} | 
*TestResultsApi* | [**delete_result_file**](docs/TestResultsApi.md#delete_result_file) | **DELETE** /api/v2/results/{resultId}/files/{fileId} | 
*TestResultsApi* | [**get_result_by_id**](docs/TestResultsApi.md#get_result_by_id) | **GET** /api/v2/results/{resultId} | 
*TestResultsApi* | [**get_result_download_all_by_id**](docs/TestResultsApi.md#get_result_download_all_by_id) | **GET** /api/v2/results/{resultId}/download-all/{downloadAllId} | 
*TestResultsApi* | [**get_result_download_result_config**](docs/TestResultsApi.md#get_result_download_result_config) | **GET** /api/v2/results/{resultId}/download-result-config | 
*TestResultsApi* | [**get_result_file_by_id**](docs/TestResultsApi.md#get_result_file_by_id) | **GET** /api/v2/results/{resultId}/files/{fileId} | 
*TestResultsApi* | [**get_result_file_content**](docs/TestResultsApi.md#get_result_file_content) | **GET** /api/v2/results/{resultId}/files/{fileId}/content | 
*TestResultsApi* | [**get_result_files**](docs/TestResultsApi.md#get_result_files) | **GET** /api/v2/results/{resultId}/files | 
*TestResultsApi* | [**get_results**](docs/TestResultsApi.md#get_results) | **GET** /api/v2/results | 
*TestResultsApi* | [**get_results_tags**](docs/TestResultsApi.md#get_results_tags) | **GET** /api/v2/results/tags | 
*TestResultsApi* | [**poll_result_generate_all**](docs/TestResultsApi.md#poll_result_generate_all) | **GET** /api/v2/results/{resultId}/operations/generate-all/{id} | 
*TestResultsApi* | [**poll_result_generate_results**](docs/TestResultsApi.md#poll_result_generate_results) | **GET** /api/v2/results/{resultId}/operations/generate-results/{id} | 
*TestResultsApi* | [**poll_result_load**](docs/TestResultsApi.md#poll_result_load) | **GET** /api/v2/results/{resultId}/operations/load/{id} | 
*TestResultsApi* | [**poll_results_batch_delete**](docs/TestResultsApi.md#poll_results_batch_delete) | **GET** /api/v2/results/operations/batch-delete/{id} | 
*TestResultsApi* | [**start_result_generate_all**](docs/TestResultsApi.md#start_result_generate_all) | **POST** /api/v2/results/{resultId}/operations/generate-all | 
*TestResultsApi* | [**start_result_generate_results**](docs/TestResultsApi.md#start_result_generate_results) | **POST** /api/v2/results/{resultId}/operations/generate-results | 
*TestResultsApi* | [**start_result_load**](docs/TestResultsApi.md#start_result_load) | **POST** /api/v2/results/{resultId}/operations/load | 
*TestResultsApi* | [**start_results_batch_delete**](docs/TestResultsApi.md#start_results_batch_delete) | **POST** /api/v2/results/operations/batch-delete | 
*UtilsApi* | [**check_eulas**](docs/UtilsApi.md#check_eulas) | **GET** /eula/v1/check | Check if all EULAs are accepted
*UtilsApi* | [**get_cert_manager_certificate**](docs/UtilsApi.md#get_cert_manager_certificate) | **GET** /api/v2/cert-manager/certificate | 
*UtilsApi* | [**get_disk_usage**](docs/UtilsApi.md#get_disk_usage) | **GET** /api/v2/disk-usage | 
*UtilsApi* | [**get_disk_usage_consumer_by_id**](docs/UtilsApi.md#get_disk_usage_consumer_by_id) | **GET** /api/v2/disk-usage/consumers/{consumerId} | 
*UtilsApi* | [**get_disk_usage_consumers**](docs/UtilsApi.md#get_disk_usage_consumers) | **GET** /api/v2/disk-usage/consumers | 
*UtilsApi* | [**get_docs**](docs/UtilsApi.md#get_docs) | **GET** /api/v2/docs | 
*UtilsApi* | [**get_docs_json**](docs/UtilsApi.md#get_docs_json) | **GET** /api/v2/docs.json | 
*UtilsApi* | [**get_docs_yaml**](docs/UtilsApi.md#get_docs_yaml) | **GET** /api/v2/docs.yaml | 
*UtilsApi* | [**get_eula**](docs/UtilsApi.md#get_eula) | **GET** /eula/v1/eula/CyPerf | Retrieve EULA detail
*UtilsApi* | [**get_log_config**](docs/UtilsApi.md#get_log_config) | **GET** /api/v2/log-config | 
*UtilsApi* | [**get_time**](docs/UtilsApi.md#get_time) | **GET** /api/v2/time | 
*UtilsApi* | [**list_eulas**](docs/UtilsApi.md#list_eulas) | **GET** /eula/v1/eula | list of EULAs
*UtilsApi* | [**poll_cert_manager_generate**](docs/UtilsApi.md#poll_cert_manager_generate) | **GET** /api/v2/cert-manager/operations/generate/{id} | 
*UtilsApi* | [**poll_cert_manager_upload**](docs/UtilsApi.md#poll_cert_manager_upload) | **GET** /api/v2/cert-manager/operations/upload/{id} | 
*UtilsApi* | [**poll_disk_usage_cleanup_diagnostics**](docs/UtilsApi.md#poll_disk_usage_cleanup_diagnostics) | **GET** /api/v2/disk-usage/operations/cleanup-diagnostics/{id} | 
*UtilsApi* | [**poll_disk_usage_cleanup_logs**](docs/UtilsApi.md#poll_disk_usage_cleanup_logs) | **GET** /api/v2/disk-usage/operations/cleanup-logs/{id} | 
*UtilsApi* | [**poll_disk_usage_cleanup_migration**](docs/UtilsApi.md#poll_disk_usage_cleanup_migration) | **GET** /api/v2/disk-usage/operations/cleanup-migration/{id} | 
*UtilsApi* | [**poll_disk_usage_cleanup_notifications**](docs/UtilsApi.md#poll_disk_usage_cleanup_notifications) | **GET** /api/v2/disk-usage/operations/cleanup-notifications/{id} | 
*UtilsApi* | [**poll_disk_usage_cleanup_results**](docs/UtilsApi.md#poll_disk_usage_cleanup_results) | **GET** /api/v2/disk-usage/operations/cleanup-results/{id} | 
*UtilsApi* | [**post_eula**](docs/UtilsApi.md#post_eula) | **POST** /eula/v1/eula/CyPerf | Update properties an EULA
*UtilsApi* | [**start_cert_manager_generate**](docs/UtilsApi.md#start_cert_manager_generate) | **POST** /api/v2/cert-manager/operations/generate | 
*UtilsApi* | [**start_cert_manager_upload**](docs/UtilsApi.md#start_cert_manager_upload) | **POST** /api/v2/cert-manager/operations/upload | 
*UtilsApi* | [**start_disk_usage_cleanup_diagnostics**](docs/UtilsApi.md#start_disk_usage_cleanup_diagnostics) | **POST** /api/v2/disk-usage/operations/cleanup-diagnostics | 
*UtilsApi* | [**start_disk_usage_cleanup_logs**](docs/UtilsApi.md#start_disk_usage_cleanup_logs) | **POST** /api/v2/disk-usage/operations/cleanup-logs | 
*UtilsApi* | [**start_disk_usage_cleanup_migration**](docs/UtilsApi.md#start_disk_usage_cleanup_migration) | **POST** /api/v2/disk-usage/operations/cleanup-migration | 
*UtilsApi* | [**start_disk_usage_cleanup_notifications**](docs/UtilsApi.md#start_disk_usage_cleanup_notifications) | **POST** /api/v2/disk-usage/operations/cleanup-notifications | 
*UtilsApi* | [**start_disk_usage_cleanup_results**](docs/UtilsApi.md#start_disk_usage_cleanup_results) | **POST** /api/v2/disk-usage/operations/cleanup-results | 
*UtilsApi* | [**update_log_config**](docs/UtilsApi.md#update_log_config) | **PUT** /api/v2/log-config | 


## Documentation For Models

 - [APILink](docs/APILink.md)
 - [APIRelationship](docs/APIRelationship.md)
 - [Action](docs/Action.md)
 - [ActionBase](docs/ActionBase.md)
 - [ActionInput](docs/ActionInput.md)
 - [ActionInputFindParam](docs/ActionInputFindParam.md)
 - [ActionMetadata](docs/ActionMetadata.md)
 - [ActivationCodeInfo](docs/ActivationCodeInfo.md)
 - [ActivationCodeListRequest](docs/ActivationCodeListRequest.md)
 - [ActivationCodeRequest](docs/ActivationCodeRequest.md)
 - [AddActionInfo](docs/AddActionInfo.md)
 - [AddInput](docs/AddInput.md)
 - [AdvancedSettings](docs/AdvancedSettings.md)
 - [Agent](docs/Agent.md)
 - [AgentAssignmentByPort](docs/AgentAssignmentByPort.md)
 - [AgentAssignmentDetails](docs/AgentAssignmentDetails.md)
 - [AgentAssignments](docs/AgentAssignments.md)
 - [AgentCPUInfo](docs/AgentCPUInfo.md)
 - [AgentFeatures](docs/AgentFeatures.md)
 - [AgentOptimizationMode](docs/AgentOptimizationMode.md)
 - [AgentRelease](docs/AgentRelease.md)
 - [AgentReservation](docs/AgentReservation.md)
 - [AgentToBeRebooted](docs/AgentToBeRebooted.md)
 - [AgentsGroup](docs/AgentsGroup.md)
 - [AppExchange](docs/AppExchange.md)
 - [AppFlow](docs/AppFlow.md)
 - [AppFlowDesc](docs/AppFlowDesc.md)
 - [AppFlowInput](docs/AppFlowInput.md)
 - [AppFlowInputFindParam](docs/AppFlowInputFindParam.md)
 - [AppId](docs/AppId.md)
 - [AppMode](docs/AppMode.md)
 - [Application](docs/Application.md)
 - [ApplicationProfile](docs/ApplicationProfile.md)
 - [ApplicationType](docs/ApplicationType.md)
 - [AppsecApp](docs/AppsecApp.md)
 - [AppsecAppMetadata](docs/AppsecAppMetadata.md)
 - [AppsecAttack](docs/AppsecAttack.md)
 - [AppsecConfig](docs/AppsecConfig.md)
 - [ArchiveInfo](docs/ArchiveInfo.md)
 - [ArrayV2ElementMetadata](docs/ArrayV2ElementMetadata.md)
 - [AsyncContext](docs/AsyncContext.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [Attack](docs/Attack.md)
 - [AttackAction](docs/AttackAction.md)
 - [AttackMetadata](docs/AttackMetadata.md)
 - [AttackMetadataKeywordsInner](docs/AttackMetadataKeywordsInner.md)
 - [AttackObjectivesAndTimeline](docs/AttackObjectivesAndTimeline.md)
 - [AttackProfile](docs/AttackProfile.md)
 - [AttackTimelineSegment](docs/AttackTimelineSegment.md)
 - [AttackTrack](docs/AttackTrack.md)
 - [AuthMethodType](docs/AuthMethodType.md)
 - [AuthProfile](docs/AuthProfile.md)
 - [AuthProfileMetadata](docs/AuthProfileMetadata.md)
 - [AuthSettings](docs/AuthSettings.md)
 - [Authenticate200Response](docs/Authenticate200Response.md)
 - [AuthenticationSettings](docs/AuthenticationSettings.md)
 - [AutomaticIpType](docs/AutomaticIpType.md)
 - [Broker](docs/Broker.md)
 - [CaptureInput](docs/CaptureInput.md)
 - [CaptureInputFindParam](docs/CaptureInputFindParam.md)
 - [CaptureSettings](docs/CaptureSettings.md)
 - [Category](docs/Category.md)
 - [CategoryFilter](docs/CategoryFilter.md)
 - [CategoryValue](docs/CategoryValue.md)
 - [CertConfig](docs/CertConfig.md)
 - [Certificate](docs/Certificate.md)
 - [ChassisInfo](docs/ChassisInfo.md)
 - [Choice](docs/Choice.md)
 - [CipherTLS12](docs/CipherTLS12.md)
 - [CipherTLS13](docs/CipherTLS13.md)
 - [CiscoAnyConnectSettings](docs/CiscoAnyConnectSettings.md)
 - [CiscoEncapsulation](docs/CiscoEncapsulation.md)
 - [ClearPortsOwnershipOperation](docs/ClearPortsOwnershipOperation.md)
 - [Command](docs/Command.md)
 - [ComputeNode](docs/ComputeNode.md)
 - [Config](docs/Config.md)
 - [ConfigCategory](docs/ConfigCategory.md)
 - [ConfigId](docs/ConfigId.md)
 - [ConfigMetadata](docs/ConfigMetadata.md)
 - [ConfigValidation](docs/ConfigValidation.md)
 - [Conflict](docs/Conflict.md)
 - [Connection](docs/Connection.md)
 - [ConnectionPersistence](docs/ConnectionPersistence.md)
 - [Consumer](docs/Consumer.md)
 - [Controller](docs/Controller.md)
 - [CountedFeatureConsumer](docs/CountedFeatureConsumer.md)
 - [CountedFeatureStats](docs/CountedFeatureStats.md)
 - [CreateAppOperation](docs/CreateAppOperation.md)
 - [CreateAppOrAttackOperationInput](docs/CreateAppOrAttackOperationInput.md)
 - [CustomDashboards](docs/CustomDashboards.md)
 - [CustomImportHandler](docs/CustomImportHandler.md)
 - [CustomStat](docs/CustomStat.md)
 - [DNSResolver](docs/DNSResolver.md)
 - [DNSServer](docs/DNSServer.md)
 - [DTLSSettings](docs/DTLSSettings.md)
 - [DUTNetwork](docs/DUTNetwork.md)
 - [Dashboard](docs/Dashboard.md)
 - [DataType](docs/DataType.md)
 - [DataTypeValuesInner](docs/DataTypeValuesInner.md)
 - [Definition](docs/Definition.md)
 - [DeleteInput](docs/DeleteInput.md)
 - [DhP1Group](docs/DhP1Group.md)
 - [DiagnosticComponent](docs/DiagnosticComponent.md)
 - [DiagnosticComponentContext](docs/DiagnosticComponentContext.md)
 - [DiagnosticOptions](docs/DiagnosticOptions.md)
 - [DiskUsage](docs/DiskUsage.md)
 - [ESPOverUDPSettings](docs/ESPOverUDPSettings.md)
 - [EditActionInput](docs/EditActionInput.md)
 - [EditAppOperation](docs/EditAppOperation.md)
 - [EffectivePorts](docs/EffectivePorts.md)
 - [EmulatedRouter](docs/EmulatedRouter.md)
 - [EmulatedRouterRange](docs/EmulatedRouterRange.md)
 - [EmulatedSubnetConfig](docs/EmulatedSubnetConfig.md)
 - [EncP1Algorithm](docs/EncP1Algorithm.md)
 - [EncP2Algorithm](docs/EncP2Algorithm.md)
 - [Endpoint](docs/Endpoint.md)
 - [EntitlementCodeInfo](docs/EntitlementCodeInfo.md)
 - [EntitlementCodeRequest](docs/EntitlementCodeRequest.md)
 - [Enum](docs/Enum.md)
 - [ErrorDescription](docs/ErrorDescription.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [EthRange](docs/EthRange.md)
 - [EulaDetails](docs/EulaDetails.md)
 - [EulaSummary](docs/EulaSummary.md)
 - [Exchange](docs/Exchange.md)
 - [ExchangeOrder](docs/ExchangeOrder.md)
 - [ExchangePayload](docs/ExchangePayload.md)
 - [ExpectedDiskSpace](docs/ExpectedDiskSpace.md)
 - [ExpectedDiskSpaceMessage](docs/ExpectedDiskSpaceMessage.md)
 - [ExpectedDiskSpacePrettySize](docs/ExpectedDiskSpacePrettySize.md)
 - [ExpectedDiskSpaceSize](docs/ExpectedDiskSpaceSize.md)
 - [ExportAllOperation](docs/ExportAllOperation.md)
 - [ExportAppsOperationInput](docs/ExportAppsOperationInput.md)
 - [ExportFilesOperationInput](docs/ExportFilesOperationInput.md)
 - [ExportFilesRequest](docs/ExportFilesRequest.md)
 - [ExportPackageOperation](docs/ExportPackageOperation.md)
 - [ExternalResourceInfo](docs/ExternalResourceInfo.md)
 - [F5Encapsulation](docs/F5Encapsulation.md)
 - [F5Settings](docs/F5Settings.md)
 - [Feature](docs/Feature.md)
 - [FeatureReservation](docs/FeatureReservation.md)
 - [FeatureReservationReserve](docs/FeatureReservationReserve.md)
 - [FileMetadata](docs/FileMetadata.md)
 - [FileValue](docs/FileValue.md)
 - [Filter](docs/Filter.md)
 - [FilteredStat](docs/FilteredStat.md)
 - [FindParamMatchesOperation](docs/FindParamMatchesOperation.md)
 - [FortinetEncapsulation](docs/FortinetEncapsulation.md)
 - [FortinetSettings](docs/FortinetSettings.md)
 - [FulfillmentRequest](docs/FulfillmentRequest.md)
 - [GenerateAllOperation](docs/GenerateAllOperation.md)
 - [GenerateCSVReportsOperation](docs/GenerateCSVReportsOperation.md)
 - [GeneratePDFReportOperation](docs/GeneratePDFReportOperation.md)
 - [GenericFile](docs/GenericFile.md)
 - [GetAgents200Response](docs/GetAgents200Response.md)
 - [GetAgents200ResponseOneOf](docs/GetAgents200ResponseOneOf.md)
 - [GetAgentsTags200Response](docs/GetAgentsTags200Response.md)
 - [GetAgentsTags200ResponseOneOf](docs/GetAgentsTags200ResponseOneOf.md)
 - [GetAsyncOperationResult200Response](docs/GetAsyncOperationResult200Response.md)
 - [GetAttacksOperation](docs/GetAttacksOperation.md)
 - [GetBrokers200Response](docs/GetBrokers200Response.md)
 - [GetBrokers200ResponseOneOf](docs/GetBrokers200ResponseOneOf.md)
 - [GetCategoriesOperation](docs/GetCategoriesOperation.md)
 - [GetConfigCategories200Response](docs/GetConfigCategories200Response.md)
 - [GetConfigCategories200ResponseOneOf](docs/GetConfigCategories200ResponseOneOf.md)
 - [GetConfigs200Response](docs/GetConfigs200Response.md)
 - [GetConfigs200ResponseOneOf](docs/GetConfigs200ResponseOneOf.md)
 - [GetControllers200Response](docs/GetControllers200Response.md)
 - [GetControllers200ResponseOneOf](docs/GetControllers200ResponseOneOf.md)
 - [GetDiskUsageConsumers200Response](docs/GetDiskUsageConsumers200Response.md)
 - [GetDiskUsageConsumers200ResponseOneOf](docs/GetDiskUsageConsumers200ResponseOneOf.md)
 - [GetLicenseAsyncOperationResult200Response](docs/GetLicenseAsyncOperationResult200Response.md)
 - [GetLicenseServers200Response](docs/GetLicenseServers200Response.md)
 - [GetLicenseServers200ResponseOneOf](docs/GetLicenseServers200ResponseOneOf.md)
 - [GetNotifications200Response](docs/GetNotifications200Response.md)
 - [GetNotifications200ResponseOneOf](docs/GetNotifications200ResponseOneOf.md)
 - [GetResourcesApplicationTypes200Response](docs/GetResourcesApplicationTypes200Response.md)
 - [GetResourcesApplicationTypes200ResponseOneOf](docs/GetResourcesApplicationTypes200ResponseOneOf.md)
 - [GetResourcesApps200Response](docs/GetResourcesApps200Response.md)
 - [GetResourcesApps200ResponseOneOf](docs/GetResourcesApps200ResponseOneOf.md)
 - [GetResourcesAttacks200Response](docs/GetResourcesAttacks200Response.md)
 - [GetResourcesAttacks200ResponseOneOf](docs/GetResourcesAttacks200ResponseOneOf.md)
 - [GetResourcesAuthProfiles200Response](docs/GetResourcesAuthProfiles200Response.md)
 - [GetResourcesAuthProfiles200ResponseOneOf](docs/GetResourcesAuthProfiles200ResponseOneOf.md)
 - [GetResourcesCertificates200Response](docs/GetResourcesCertificates200Response.md)
 - [GetResourcesCertificates200ResponseOneOf](docs/GetResourcesCertificates200ResponseOneOf.md)
 - [GetResourcesCustomImportOperations200Response](docs/GetResourcesCustomImportOperations200Response.md)
 - [GetResourcesCustomImportOperations200ResponseOneOf](docs/GetResourcesCustomImportOperations200ResponseOneOf.md)
 - [GetResourcesHttpProfiles200Response](docs/GetResourcesHttpProfiles200Response.md)
 - [GetResourcesHttpProfiles200ResponseOneOf](docs/GetResourcesHttpProfiles200ResponseOneOf.md)
 - [GetResultFiles200Response](docs/GetResultFiles200Response.md)
 - [GetResultFiles200ResponseOneOf](docs/GetResultFiles200ResponseOneOf.md)
 - [GetResultStats200Response](docs/GetResultStats200Response.md)
 - [GetResultStats200ResponseOneOf](docs/GetResultStats200ResponseOneOf.md)
 - [GetResults200Response](docs/GetResults200Response.md)
 - [GetResults200ResponseOneOf](docs/GetResults200ResponseOneOf.md)
 - [GetResultsTags200Response](docs/GetResultsTags200Response.md)
 - [GetResultsTags200ResponseOneOf](docs/GetResultsTags200ResponseOneOf.md)
 - [GetSessionMeta200Response](docs/GetSessionMeta200Response.md)
 - [GetSessionMeta200ResponseOneOf](docs/GetSessionMeta200ResponseOneOf.md)
 - [GetSessions200Response](docs/GetSessions200Response.md)
 - [GetSessions200ResponseOneOf](docs/GetSessions200ResponseOneOf.md)
 - [GetStatsPlugins200Response](docs/GetStatsPlugins200Response.md)
 - [GetStatsPlugins200ResponseOneOf](docs/GetStatsPlugins200ResponseOneOf.md)
 - [GetStrikesOperation](docs/GetStrikesOperation.md)
 - [HTTPProfile](docs/HTTPProfile.md)
 - [HTTPReqMeta](docs/HTTPReqMeta.md)
 - [HTTPResMeta](docs/HTTPResMeta.md)
 - [HTTPVersion](docs/HTTPVersion.md)
 - [HashP1Algorithm](docs/HashP1Algorithm.md)
 - [HashP2Algorithm](docs/HashP2Algorithm.md)
 - [HealthCheckConfig](docs/HealthCheckConfig.md)
 - [HealthIssue](docs/HealthIssue.md)
 - [HostID](docs/HostID.md)
 - [IPNetwork](docs/IPNetwork.md)
 - [IPRange](docs/IPRange.md)
 - [IPSecRange](docs/IPSecRange.md)
 - [IPSecStack](docs/IPSecStack.md)
 - [IdPSignatureAlgo](docs/IdPSignatureAlgo.md)
 - [ImportAllOperation](docs/ImportAllOperation.md)
 - [ImportOfflineLicenseResult](docs/ImportOfflineLicenseResult.md)
 - [IngestOperation](docs/IngestOperation.md)
 - [InnerIPRange](docs/InnerIPRange.md)
 - [Interface](docs/Interface.md)
 - [IpMask](docs/IpMask.md)
 - [IpPreference](docs/IpPreference.md)
 - [IpVer](docs/IpVer.md)
 - [License](docs/License.md)
 - [LicenseReceipt](docs/LicenseReceipt.md)
 - [LicenseServerMetadata](docs/LicenseServerMetadata.md)
 - [Link](docs/Link.md)
 - [LoadConfigOperation](docs/LoadConfigOperation.md)
 - [LocalSubnetConfig](docs/LocalSubnetConfig.md)
 - [LogConfig](docs/LogConfig.md)
 - [LogLevel](docs/LogLevel.md)
 - [MacDtlsStack](docs/MacDtlsStack.md)
 - [MappingType](docs/MappingType.md)
 - [MarkedAsDeleted](docs/MarkedAsDeleted.md)
 - [MediaFile](docs/MediaFile.md)
 - [MediaTrack](docs/MediaTrack.md)
 - [Metadata](docs/Metadata.md)
 - [MosMode](docs/MosMode.md)
 - [NameIdFormat](docs/NameIdFormat.md)
 - [NameServer](docs/NameServer.md)
 - [NetworkMapping](docs/NetworkMapping.md)
 - [NetworkMeshing](docs/NetworkMeshing.md)
 - [NetworkProfile](docs/NetworkProfile.md)
 - [NetworkSegmentBase](docs/NetworkSegmentBase.md)
 - [NodesByController](docs/NodesByController.md)
 - [NodesPowerCycleOperation](docs/NodesPowerCycleOperation.md)
 - [Notification](docs/Notification.md)
 - [NotificationCounts](docs/NotificationCounts.md)
 - [NtpInfo](docs/NtpInfo.md)
 - [ObjectiveType](docs/ObjectiveType.md)
 - [ObjectiveUnit](docs/ObjectiveUnit.md)
 - [ObjectiveValueEntry](docs/ObjectiveValueEntry.md)
 - [ObjectivesAndTimeline](docs/ObjectivesAndTimeline.md)
 - [OpenAPIDefinitions](docs/OpenAPIDefinitions.md)
 - [P1Config](docs/P1Config.md)
 - [P2Config](docs/P2Config.md)
 - [PANGPEncapsulation](docs/PANGPEncapsulation.md)
 - [PANGPSettings](docs/PANGPSettings.md)
 - [Pair](docs/Pair.md)
 - [ParamMetadata](docs/ParamMetadata.md)
 - [ParamMetadataTypeInfo](docs/ParamMetadataTypeInfo.md)
 - [ParamMetadataTypeInfoArrayV2](docs/ParamMetadataTypeInfoArrayV2.md)
 - [ParamMetadataTypeInfoArrayV2ElementsInner](docs/ParamMetadataTypeInfoArrayV2ElementsInner.md)
 - [ParamMetadataTypeInfoInt](docs/ParamMetadataTypeInfoInt.md)
 - [ParamMetadataTypeInfoMedia](docs/ParamMetadataTypeInfoMedia.md)
 - [ParamMetadataTypeInfoString](docs/ParamMetadataTypeInfoString.md)
 - [ParamSourceType](docs/ParamSourceType.md)
 - [ParamType](docs/ParamType.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterMatch](docs/ParameterMatch.md)
 - [ParameterMetadata](docs/ParameterMetadata.md)
 - [Params](docs/Params.md)
 - [ParamsEnum](docs/ParamsEnum.md)
 - [PayloadMeta](docs/PayloadMeta.md)
 - [PayloadMetadata](docs/PayloadMetadata.md)
 - [PepDUT](docs/PepDUT.md)
 - [PfsP2Group](docs/PfsP2Group.md)
 - [Plugin](docs/Plugin.md)
 - [PluginStats](docs/PluginStats.md)
 - [Port](docs/Port.md)
 - [PortSettings](docs/PortSettings.md)
 - [PortsByController](docs/PortsByController.md)
 - [PortsByNode](docs/PortsByNode.md)
 - [PrepareTestOperation](docs/PrepareTestOperation.md)
 - [PreparedTestOptions](docs/PreparedTestOptions.md)
 - [PrfP1Algorithm](docs/PrfP1Algorithm.md)
 - [ProtectedSubnetConfig](docs/ProtectedSubnetConfig.md)
 - [RTPEncryptionMode](docs/RTPEncryptionMode.md)
 - [RTPProfile](docs/RTPProfile.md)
 - [RTPProfileMeta](docs/RTPProfileMeta.md)
 - [RebootOperationInput](docs/RebootOperationInput.md)
 - [RebootPortsOperation](docs/RebootPortsOperation.md)
 - [Reference](docs/Reference.md)
 - [RegexMatch](docs/RegexMatch.md)
 - [ReleaseOperationInput](docs/ReleaseOperationInput.md)
 - [RemoteAccess](docs/RemoteAccess.md)
 - [RemoteSubnetConfig](docs/RemoteSubnetConfig.md)
 - [RenameInput](docs/RenameInput.md)
 - [ReorderActionInput](docs/ReorderActionInput.md)
 - [ReorderExchangesInput](docs/ReorderExchangesInput.md)
 - [ReplayCapture](docs/ReplayCapture.md)
 - [RequiredFileTypes](docs/RequiredFileTypes.md)
 - [ReserveOperationInput](docs/ReserveOperationInput.md)
 - [ResultFileMetadata](docs/ResultFileMetadata.md)
 - [ResultMetadata](docs/ResultMetadata.md)
 - [ResultsGroup](docs/ResultsGroup.md)
 - [SaveConfigOperation](docs/SaveConfigOperation.md)
 - [Scenario](docs/Scenario.md)
 - [SecondaryObjective](docs/SecondaryObjective.md)
 - [SegmentType](docs/SegmentType.md)
 - [SelectedEnv](docs/SelectedEnv.md)
 - [Session](docs/Session.md)
 - [SessionReuseMethodTLS12](docs/SessionReuseMethodTLS12.md)
 - [SessionReuseMethodTLS13](docs/SessionReuseMethodTLS13.md)
 - [SetAggregationModeOperation](docs/SetAggregationModeOperation.md)
 - [SetAppOperation](docs/SetAppOperation.md)
 - [SetDpdkModeOperationInput](docs/SetDpdkModeOperationInput.md)
 - [SetLinkStateOperation](docs/SetLinkStateOperation.md)
 - [SetNtpOperationInput](docs/SetNtpOperationInput.md)
 - [SimulatedIdP](docs/SimulatedIdP.md)
 - [Snapshot](docs/Snapshot.md)
 - [SortBodyField](docs/SortBodyField.md)
 - [SpecificObjective](docs/SpecificObjective.md)
 - [StartAgentsBatchDeleteRequestInner](docs/StartAgentsBatchDeleteRequestInner.md)
 - [StatelessStream](docs/StatelessStream.md)
 - [StaticARPEntry](docs/StaticARPEntry.md)
 - [StatsResult](docs/StatsResult.md)
 - [SteadySegment](docs/SteadySegment.md)
 - [StepSegment](docs/StepSegment.md)
 - [StreamDirection](docs/StreamDirection.md)
 - [StreamPayloadType](docs/StreamPayloadType.md)
 - [StreamProfile](docs/StreamProfile.md)
 - [SupportedGroupTLS13](docs/SupportedGroupTLS13.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [TLSProfile](docs/TLSProfile.md)
 - [TcpProfile](docs/TcpProfile.md)
 - [TestInfo](docs/TestInfo.md)
 - [TestStateChangedOperation](docs/TestStateChangedOperation.md)
 - [TimeValue](docs/TimeValue.md)
 - [TimelineSegment](docs/TimelineSegment.md)
 - [TimelineSegmentBase](docs/TimelineSegmentBase.md)
 - [TimelineSegmentUnion](docs/TimelineSegmentUnion.md)
 - [Timers](docs/Timers.md)
 - [Track](docs/Track.md)
 - [TrackType](docs/TrackType.md)
 - [TrafficAgentInfo](docs/TrafficAgentInfo.md)
 - [TrafficProfileBase](docs/TrafficProfileBase.md)
 - [TrafficSettings](docs/TrafficSettings.md)
 - [TransportProfile](docs/TransportProfile.md)
 - [TransportProfileBase](docs/TransportProfileBase.md)
 - [TunnelRange](docs/TunnelRange.md)
 - [TunnelSettings](docs/TunnelSettings.md)
 - [TunnelStack](docs/TunnelStack.md)
 - [TypeArrayV2Metadata](docs/TypeArrayV2Metadata.md)
 - [TypeInfoMetadata](docs/TypeInfoMetadata.md)
 - [TypeIntMetadata](docs/TypeIntMetadata.md)
 - [TypeMediaMetadata](docs/TypeMediaMetadata.md)
 - [TypeStringMetadata](docs/TypeStringMetadata.md)
 - [UdpProfile](docs/UdpProfile.md)
 - [UpdateNetworkMapping](docs/UpdateNetworkMapping.md)
 - [VLANRange](docs/VLANRange.md)
 - [ValidationMessage](docs/ValidationMessage.md)
 - [Version](docs/Version.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: 
 - **offline_access**: Required.
 - **openid**: Required.

<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: /auth/realms/keysight/protocol/openid-connect/auth
- **Scopes**: 
 - **offline_access**: Required.
 - **openid**: Required.


## Author

support@keysight.com


