# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AgentReservation(BaseModel):
    """
    AgentReservation
    """ # noqa: E501
    agent_id: Optional[StrictStr] = Field(default=None, alias="agentId")
    agent_payload_names: Optional[List[StrictStr]] = Field(default=None, alias="agentPayloadNames")
    general_purpose_cpu_percent: Optional[StrictInt] = Field(default=None, alias="generalPurposeCPUPercent")
    interfaces: Optional[List[StrictStr]] = None
    ip_address_version_used: Optional[StrictStr] = Field(default=None, alias="ipAddressVersionUsed")
    optimization_mode: Optional[StrictStr] = Field(default=None, alias="optimizationMode")
    __properties: ClassVar[List[str]] = ["agentId", "agentPayloadNames", "generalPurposeCPUPercent", "interfaces", "ipAddressVersionUsed", "optimizationMode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentReservation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentReservation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "agentId": obj.get("agentId"),
                        "agentPayloadNames": obj.get("agentPayloadNames"),
                        "generalPurposeCPUPercent": obj.get("generalPurposeCPUPercent"),
                        "interfaces": obj.get("interfaces"),
                        "ipAddressVersionUsed": obj.get("ipAddressVersionUsed"),
                        "optimizationMode": obj.get("optimizationMode")
            ,
            "links": obj.get("links")
        })
        return _obj


