# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.exchange_payload import ExchangePayload
from cyperf.models.generic_file import GenericFile
from cyperf.models.http_req_meta import HTTPReqMeta
from cyperf.models.http_res_meta import HTTPResMeta
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AppExchange(BaseModel):
    """
    AppExchange
    """ # noqa: E501
    c2s_payload: Optional[GenericFile] = Field(default=None, alias="c2sPayload")
    http_req_meta: Optional[HTTPReqMeta] = Field(default=None, alias="httpReqMeta")
    http_res_meta: Optional[HTTPResMeta] = Field(default=None, alias="httpResMeta")
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    payload: Optional[ExchangePayload] = None
    s2c_payload: Optional[GenericFile] = Field(default=None, alias="s2cPayload")
    __properties: ClassVar[List[str]] = ["c2sPayload", "httpReqMeta", "httpResMeta", "id", "name", "payload", "s2cPayload"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppExchange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of c2s_payload
        if self.c2s_payload:
            _dict['c2sPayload'] = self.c2s_payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of http_req_meta
        if self.http_req_meta:
            _dict['httpReqMeta'] = self.http_req_meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of http_res_meta
        if self.http_res_meta:
            _dict['httpResMeta'] = self.http_res_meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of s2c_payload
        if self.s2c_payload:
            _dict['s2cPayload'] = self.s2c_payload.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppExchange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "c2sPayload": GenericFile.from_dict(obj["c2sPayload"]) if obj.get("c2sPayload") is not None else None,
                        "httpReqMeta": HTTPReqMeta.from_dict(obj["httpReqMeta"]) if obj.get("httpReqMeta") is not None else None,
                        "httpResMeta": HTTPResMeta.from_dict(obj["httpResMeta"]) if obj.get("httpResMeta") is not None else None,
                        "id": obj.get("id"),
                        "name": obj.get("name"),
                        "payload": ExchangePayload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
                        "s2cPayload": GenericFile.from_dict(obj["s2cPayload"]) if obj.get("s2cPayload") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


