# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBytes, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from cyperf.models.api_link import APILink
from cyperf.models.app_exchange import AppExchange
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AppFlow(BaseModel):
    """
    AppFlow
    """ # noqa: E501
    display_id: Optional[StrictStr] = Field(default=None, alias="displayId")
    dst_address: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, alias="dstAddress")
    dst_port: Optional[StrictInt] = Field(default=None, alias="dstPort")
    exchanges: Optional[List[AppExchange]] = Field(default=None, description="The list of exchanges")
    id: Optional[StrictStr] = None
    links: Optional[List[APILink]] = None
    src_address: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, alias="srcAddress")
    src_port: Optional[StrictInt] = Field(default=None, alias="srcPort")
    transport_type: Optional[StrictStr] = Field(default=None, alias="transportType")
    __properties: ClassVar[List[str]] = ["displayId", "dstAddress", "dstPort", "exchanges", "id", "links", "srcAddress", "srcPort", "transportType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppFlow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "display_id",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in exchanges (list)
        _items = []
        if self.exchanges:
            for _item in self.exchanges:
                if _item:
                    _items.append(_item.to_dict())
            _dict['exchanges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppFlow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "displayId": obj.get("displayId"),
                        "dstAddress": obj.get("dstAddress"),
                        "dstPort": obj.get("dstPort"),
                        "exchanges": [AppExchange.from_dict(_item) for _item in obj["exchanges"]] if obj.get("exchanges") is not None else None,
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "srcAddress": obj.get("srcAddress"),
                        "srcPort": obj.get("srcPort"),
                        "transportType": obj.get("transportType")
            ,
            "links": obj.get("links")
        })
        return _obj


