# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.command import Command
from cyperf.models.connection import Connection
from cyperf.models.custom_stat import CustomStat
from cyperf.models.data_type import DataType
from cyperf.models.definition import Definition
from cyperf.models.endpoint import Endpoint
from cyperf.models.metadata import Metadata
from cyperf.models.parameter import Parameter
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class ApplicationType(BaseModel):
    """
    ApplicationType
    """ # noqa: E501
    commands: Optional[List[Command]] = Field(default=None, description="The commands included in the flow", alias="Commands")
    connections: Optional[List[Connection]] = Field(default=None, description="The connections included in the flow", alias="Connections")
    custom_stats: Optional[List[CustomStat]] = Field(default=None, description="The custom statistics of the application", alias="CustomStats")
    data_types: Optional[List[DataType]] = Field(default=None, description="The data types definition of the parameters", alias="DataTypes")
    definition: Optional[Definition] = Field(default=None, alias="Definition")
    description: Optional[StrictStr] = Field(default=None, description="The description of the application", alias="Description")
    endpoints: Optional[List[Endpoint]] = Field(default=None, description="The list of endpoints used by the application", alias="Endpoints")
    file_name: Optional[StrictStr] = Field(default=None, description="The name of the XML file that contains the application definition", alias="FileName")
    has_banner_command: Optional[StrictBool] = Field(default=None, description="Indicates if there is a command that is required, can only be add once and also must be the first", alias="HasBannerCommand")
    md5_content: Optional[StrictStr] = Field(default=None, description="The MD5 value of the XML file that contains the application definition.", alias="Md5Content")
    md5_metadata: Optional[StrictStr] = Field(default=None, description="The MD5 value of the XML file that contains the metadata definition.", alias="Md5Metadata")
    metadata: Optional[Metadata] = Field(default=None, alias="Metadata")
    name: Optional[StrictStr] = Field(default=None, description="The display name of the application", alias="Name")
    parameters: Optional[List[Parameter]] = Field(default=None, description="The parameters of the application", alias="Parameters")
    protocol_found: Optional[StrictBool] = Field(default=None, description="Indicates if the application protocol has been found.", alias="ProtocolFound")
    strikes: Optional[List[Command]] = Field(default=None, description="The commands and strikes included in the flow", alias="Strikes")
    supports_calibration: Optional[StrictBool] = Field(default=None, description="Indicates if the best configuration can be computed automatically", alias="SupportsCalibration")
    supports_client_http_profile: Optional[StrictBool] = Field(default=None, description="Indicates if the application uses Client HTTP profiles.", alias="SupportsClientHTTPProfile")
    supports_http_profiles: Optional[StrictBool] = Field(default=None, description="Indicates if the application uses HTTP profiles.", alias="SupportsHTTPProfiles")
    supports_server_http_profile: Optional[StrictBool] = Field(default=None, description="Indicates if the application uses Server HTTP profiles.", alias="SupportsServerHTTPProfile")
    supports_strikes: Optional[StrictBool] = Field(default=None, description="Indicates if the application supports strikes.", alias="SupportsStrikes")
    supports_tls: Optional[StrictBool] = Field(default=None, description="Indicates if the application supports TLS protocol.", alias="SupportsTLS")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the flow")
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["Commands", "Connections", "CustomStats", "DataTypes", "Definition", "Description", "Endpoints", "FileName", "HasBannerCommand", "Md5Content", "Md5Metadata", "Metadata", "Name", "Parameters", "ProtocolFound", "Strikes", "SupportsCalibration", "SupportsClientHTTPProfile", "SupportsHTTPProfiles", "SupportsServerHTTPProfile", "SupportsStrikes", "SupportsTLS", "id", "links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "connections",
            "endpoints",
            "parameters",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in commands (list)
        _items = []
        if self.commands:
            for _item in self.commands:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Commands'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in connections (list)
        _items = []
        if self.connections:
            for _item in self.connections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Connections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_stats (list)
        _items = []
        if self.custom_stats:
            for _item in self.custom_stats:
                if _item:
                    _items.append(_item.to_dict())
            _dict['CustomStats'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in data_types (list)
        _items = []
        if self.data_types:
            for _item in self.data_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['DataTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of definition
        if self.definition:
            _dict['Definition'] = self.definition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in endpoints (list)
        _items = []
        if self.endpoints:
            for _item in self.endpoints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Endpoints'] = _items
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['Metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item in self.parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in strikes (list)
        _items = []
        if self.strikes:
            for _item in self.strikes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Strikes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Commands": [Command.from_dict(_item) for _item in obj["Commands"]] if obj.get("Commands") is not None else None,
                        "Connections": [Connection.from_dict(_item) for _item in obj["Connections"]] if obj.get("Connections") is not None else None,
                        "CustomStats": [CustomStat.from_dict(_item) for _item in obj["CustomStats"]] if obj.get("CustomStats") is not None else None,
                        "DataTypes": [DataType.from_dict(_item) for _item in obj["DataTypes"]] if obj.get("DataTypes") is not None else None,
                        "Definition": Definition.from_dict(obj["Definition"]) if obj.get("Definition") is not None else None,
                        "Description": obj.get("Description"),
                        "Endpoints": [Endpoint.from_dict(_item) for _item in obj["Endpoints"]] if obj.get("Endpoints") is not None else None,
                        "FileName": obj.get("FileName"),
                        "HasBannerCommand": obj.get("HasBannerCommand"),
                        "Md5Content": obj.get("Md5Content"),
                        "Md5Metadata": obj.get("Md5Metadata"),
                        "Metadata": Metadata.from_dict(obj["Metadata"]) if obj.get("Metadata") is not None else None,
                        "Name": obj.get("Name"),
                        "Parameters": [Parameter.from_dict(_item) for _item in obj["Parameters"]] if obj.get("Parameters") is not None else None,
                        "ProtocolFound": obj.get("ProtocolFound"),
                        "Strikes": [Command.from_dict(_item) for _item in obj["Strikes"]] if obj.get("Strikes") is not None else None,
                        "SupportsCalibration": obj.get("SupportsCalibration"),
                        "SupportsClientHTTPProfile": obj.get("SupportsClientHTTPProfile"),
                        "SupportsHTTPProfiles": obj.get("SupportsHTTPProfiles"),
                        "SupportsServerHTTPProfile": obj.get("SupportsServerHTTPProfile"),
                        "SupportsStrikes": obj.get("SupportsStrikes"),
                        "SupportsTLS": obj.get("SupportsTLS"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


