# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.application import Application
from cyperf.models.appsec_app_metadata import AppsecAppMetadata
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AppsecApp(BaseModel):
    """
    AppsecApp
    """ # noqa: E501
    app: Optional[Application] = Field(default=None, alias="App")
    description: Optional[StrictStr] = Field(default=None, description="The description of the application", alias="Description")
    name: Optional[StrictStr] = Field(default=None, description="The user friendly name of the application", alias="Name")
    static: Optional[StrictBool] = Field(default=None, description="If true, the application/strike is generated from controller", alias="Static")
    user_defined: Optional[StrictBool] = Field(default=None, description="If true, the application was created by the user", alias="UserDefined")
    app_metadata: Optional[AppsecAppMetadata] = Field(default=None, alias="appMetadata")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the application")
    last_modified: Optional[StrictInt] = Field(default=None, alias="lastModified")
    links: Optional[List[APILink]] = None
    owner: Optional[StrictStr] = Field(default=None, description="The friendly display name of the application's owner")
    owner_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the application's owner", alias="ownerId")
    __properties: ClassVar[List[str]] = ["App", "Description", "Name", "Static", "UserDefined", "appMetadata", "id", "lastModified", "links", "owner", "ownerId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppsecApp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "static",
            "user_defined",
            "id",
            "owner",
            "owner_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['App'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of app_metadata
        if self.app_metadata:
            _dict['appMetadata'] = self.app_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppsecApp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "App": Application.from_dict(obj["App"]) if obj.get("App") is not None else None,
                        "Description": obj.get("Description"),
                        "Name": obj.get("Name"),
                        "Static": obj.get("Static"),
                        "UserDefined": obj.get("UserDefined"),
                        "appMetadata": AppsecAppMetadata.from_dict(obj["appMetadata"]) if obj.get("appMetadata") is not None else None,
                        "id": obj.get("id"),
                        "lastModified": obj.get("lastModified"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "owner": obj.get("owner"),
                        "ownerId": obj.get("ownerId")
            ,
            "links": obj.get("links")
        })
        return _obj


