# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.attack_metadata_keywords_inner import AttackMetadataKeywordsInner
from cyperf.models.reference import Reference
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AttackMetadata(BaseModel):
    """
    AttackMetadata
    """ # noqa: E501
    cve_count: Optional[StrictInt] = Field(default=None, description="The number of CVE references associated with the attack", alias="CveCount")
    direction: Optional[StrictStr] = Field(default=None, description="The aggregated direction of the strike included in the attack", alias="Direction")
    keywords: Optional[List[AttackMetadataKeywordsInner]] = Field(default=None, description="The aggregated keywords of the attack", alias="Keywords")
    legacy_names: Optional[List[StrictStr]] = Field(default=None, alias="LegacyNames")
    references: Optional[List[Reference]] = Field(default=None, description="The aggregated references of the attack", alias="References")
    severity: Optional[StrictStr] = Field(default=None, description="The aggregated severity of the strike included in the attack", alias="Severity")
    strikes_count: Optional[StrictInt] = Field(default=None, description="The number of strikes associated with the attack", alias="StrikesCount")
    __properties: ClassVar[List[str]] = ["CveCount", "Direction", "Keywords", "LegacyNames", "References", "Severity", "StrikesCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttackMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in keywords (list)
        _items = []
        if self.keywords:
            for _item in self.keywords:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Keywords'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item in self.references:
                if _item:
                    _items.append(_item.to_dict())
            _dict['References'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttackMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "CveCount": obj.get("CveCount"),
                        "Direction": obj.get("Direction"),
                        "Keywords": [AttackMetadataKeywordsInner.from_dict(_item) for _item in obj["Keywords"]] if obj.get("Keywords") is not None else None,
                        "LegacyNames": obj.get("LegacyNames"),
                        "References": [Reference.from_dict(_item) for _item in obj["References"]] if obj.get("References") is not None else None,
                        "Severity": obj.get("Severity"),
                        "StrikesCount": obj.get("StrikesCount")
            ,
            "links": obj.get("links")
        })
        return _obj


