# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from cyperf.models.api_link import APILink
from cyperf.models.attack import Attack
from cyperf.models.attack_objectives_and_timeline import AttackObjectivesAndTimeline
from cyperf.models.external_resource_info import ExternalResourceInfo
from cyperf.models.network_mapping import NetworkMapping
from cyperf.models.traffic_settings import TrafficSettings
from cyperf.models.update_network_mapping import UpdateNetworkMapping
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AttackProfile(BaseModel):
    """
    AttackProfile
    """ # noqa: E501
    active: Optional[StrictBool] = Field(default=None, description="Indicates whether the profile is enabled or not.", alias="Active")
    traffic_settings: Optional[TrafficSettings] = Field(default=None, alias="TrafficSettings")
    id: Optional[StrictStr] = None
    links: Optional[List[APILink]] = None
    attacks: Optional[List[Attack]] = Field(default=None, alias="Attacks")
    default_network_mapping: Optional[NetworkMapping] = Field(default=None, alias="DefaultNetworkMapping")
    name: StrictStr = Field(alias="Name")
    objectives_and_timeline: Optional[AttackObjectivesAndTimeline] = Field(default=None, alias="ObjectivesAndTimeline")
    add_attacks: Optional[List[ExternalResourceInfo]] = Field(default=None, alias="add-attacks")
    _add_attacks_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,AddAttacks" })
    modify_excluded_dut_recursively: Optional[List[UpdateNetworkMapping]] = Field(default=None, alias="modify-excluded-dut-recursively")
    _modify_excluded_dut_recursively_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,UpdateAttackProfileNetworkMapping" })
    modify_tags_recursively: Optional[List[UpdateNetworkMapping]] = Field(default=None, alias="modify-tags-recursively")
    _modify_tags_recursively_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,UpdateAttackProfileNetworkMapping" })
    reset_tags_to_default: Optional[List[Union[StrictBytes, StrictStr]]] = Field(default=None, alias="reset-tags-to-default")
    _reset_tags_to_default_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,ResetAttackProfileNetworkMapping" })
    __properties: ClassVar[List[str]] = ["Active", "TrafficSettings", "id", "links", "Attacks", "DefaultNetworkMapping", "Name", "ObjectivesAndTimeline", "add-attacks", "modify-excluded-dut-recursively", "modify-tags-recursively", "reset-tags-to-default"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttackProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of traffic_settings
        if self.traffic_settings:
            _dict['TrafficSettings'] = self.traffic_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attacks (list)
        _items = []
        if self.attacks:
            for _item in self.attacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Attacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of default_network_mapping
        if self.default_network_mapping:
            _dict['DefaultNetworkMapping'] = self.default_network_mapping.to_dict()
        # override the default output from pydantic by calling `to_dict()` of objectives_and_timeline
        if self.objectives_and_timeline:
            _dict['ObjectivesAndTimeline'] = self.objectives_and_timeline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in add_attacks (list)
        _items = []
        if self.add_attacks:
            for _item in self.add_attacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['add-attacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in modify_excluded_dut_recursively (list)
        _items = []
        if self.modify_excluded_dut_recursively:
            for _item in self.modify_excluded_dut_recursively:
                if _item:
                    _items.append(_item.to_dict())
            _dict['modify-excluded-dut-recursively'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in modify_tags_recursively (list)
        _items = []
        if self.modify_tags_recursively:
            for _item in self.modify_tags_recursively:
                if _item:
                    _items.append(_item.to_dict())
            _dict['modify-tags-recursively'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttackProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Active": obj.get("Active"),
                        "TrafficSettings": TrafficSettings.from_dict(obj["TrafficSettings"]) if obj.get("TrafficSettings") is not None else None,
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "Attacks": [Attack.from_dict(_item) for _item in obj["Attacks"]] if obj.get("Attacks") is not None else None,
                        "DefaultNetworkMapping": NetworkMapping.from_dict(obj["DefaultNetworkMapping"]) if obj.get("DefaultNetworkMapping") is not None else None,
                        "Name": obj.get("Name"),
                        "ObjectivesAndTimeline": AttackObjectivesAndTimeline.from_dict(obj["ObjectivesAndTimeline"]) if obj.get("ObjectivesAndTimeline") is not None else None,
                        "add-attacks": [ExternalResourceInfo.from_dict(_item) for _item in obj["add-attacks"]] if obj.get("add-attacks") is not None else None,
                        "modify-excluded-dut-recursively": [UpdateNetworkMapping.from_dict(_item) for _item in obj["modify-excluded-dut-recursively"]] if obj.get("modify-excluded-dut-recursively") is not None else None,
                        "modify-tags-recursively": [UpdateNetworkMapping.from_dict(_item) for _item in obj["modify-tags-recursively"]] if obj.get("modify-tags-recursively") is not None else None,
                        "reset-tags-to-default": obj.get("reset-tags-to-default")
            ,
            "links": obj.get("links")
        })
        return _obj


