# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.auth_profile_metadata import AuthProfileMetadata
from cyperf.models.connection import Connection
from cyperf.models.data_type import DataType
from cyperf.models.endpoint import Endpoint
from cyperf.models.parameter import Parameter
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AuthProfile(BaseModel):
    """
    AuthProfile
    """ # noqa: E501
    connections: Optional[List[Connection]] = Field(default=None, description="The connections included in the flow", alias="Connections")
    data_types: Optional[List[DataType]] = Field(default=None, description="The data types definition of the parameters", alias="DataTypes")
    endpoints: Optional[List[Endpoint]] = Field(default=None, description="The list of endpoints used by the authentication profile", alias="Endpoints")
    file_name: Optional[StrictStr] = Field(default=None, description="The name of the XML file that contains the authentication profile definition", alias="FileName")
    metadata: Optional[AuthProfileMetadata] = Field(default=None, alias="Metadata")
    parameters: Optional[List[Parameter]] = Field(default=None, description="The parameters of the authentication profile", alias="Parameters")
    description: Optional[StrictStr] = Field(default=None, description="The user friendly description of the Auth Profile")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the profile")
    links: Optional[List[APILink]] = None
    type: Optional[StrictStr] = Field(default=None, description="The type of the authentication profile")
    __properties: ClassVar[List[str]] = ["Connections", "DataTypes", "Endpoints", "FileName", "Metadata", "Parameters", "description", "id", "links", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "connections",
            "endpoints",
            "parameters",
            "description",
            "id",
            "type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in connections (list)
        _items = []
        if self.connections:
            for _item in self.connections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Connections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in data_types (list)
        _items = []
        if self.data_types:
            for _item in self.data_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['DataTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in endpoints (list)
        _items = []
        if self.endpoints:
            for _item in self.endpoints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Endpoints'] = _items
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['Metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item in self.parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Connections": [Connection.from_dict(_item) for _item in obj["Connections"]] if obj.get("Connections") is not None else None,
                        "DataTypes": [DataType.from_dict(_item) for _item in obj["DataTypes"]] if obj.get("DataTypes") is not None else None,
                        "Endpoints": [Endpoint.from_dict(_item) for _item in obj["Endpoints"]] if obj.get("Endpoints") is not None else None,
                        "FileName": obj.get("FileName"),
                        "Metadata": AuthProfileMetadata.from_dict(obj["Metadata"]) if obj.get("Metadata") is not None else None,
                        "Parameters": [Parameter.from_dict(_item) for _item in obj["Parameters"]] if obj.get("Parameters") is not None else None,
                        "description": obj.get("description"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "type": obj.get("type")
            ,
            "links": obj.get("links")
        })
        return _obj


