# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.enum import Enum
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AuthProfileMetadata(BaseModel):
    """
    AuthProfileMetadata
    """ # noqa: E501
    auth_method: Optional[Enum] = Field(default=None, alias="AuthMethod")
    explicit_proxy: Optional[StrictBool] = Field(default=None, description="This is an authentication profile used along with an explicit proxy", alias="ExplicitProxy")
    idp_type: Optional[Enum] = Field(default=None, alias="IDPType")
    sgw_name: Optional[StrictStr] = Field(default=None, description="The name of the secure gateway", alias="SGWName")
    sgw_type: Optional[StrictStr] = Field(default=None, description="The type of the secure gateway", alias="SGWType")
    sgw_type_value: Optional[StrictStr] = Field(default=None, description="The agent secure gateway type value of the secure gateway type", alias="SGWTypeValue")
    __properties: ClassVar[List[str]] = ["AuthMethod", "ExplicitProxy", "IDPType", "SGWName", "SGWType", "SGWTypeValue"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthProfileMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auth_method
        if self.auth_method:
            _dict['AuthMethod'] = self.auth_method.to_dict()
        # override the default output from pydantic by calling `to_dict()` of idp_type
        if self.idp_type:
            _dict['IDPType'] = self.idp_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthProfileMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "AuthMethod": Enum.from_dict(obj["AuthMethod"]) if obj.get("AuthMethod") is not None else None,
                        "ExplicitProxy": obj.get("ExplicitProxy"),
                        "IDPType": Enum.from_dict(obj["IDPType"]) if obj.get("IDPType") is not None else None,
                        "SGWName": obj.get("SGWName"),
                        "SGWType": obj.get("SGWType"),
                        "SGWTypeValue": obj.get("SGWTypeValue")
            ,
            "links": obj.get("links")
        })
        return _obj


