# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.auth_method_type import AuthMethodType
from cyperf.models.params import Params
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class AuthSettings(BaseModel):
    """
    AuthSettings
    """ # noqa: E501
    auth_method: Optional[AuthMethodType] = Field(default=None, alias="AuthMethod")
    auth_param: Optional[Params] = Field(default=None, alias="AuthParam")
    certificate_file: Optional[Params] = Field(default=None, description="The authentication certificate file of the VPN tunnel.", alias="CertificateFile")
    key_file: Optional[Params] = Field(default=None, description="The authentication key file of the VPN tunnel.", alias="KeyFile")
    key_file_password: Optional[StrictStr] = Field(default=None, description="The key file password of the TLS VPN authentication.", alias="KeyFilePassword")
    passwords: Optional[List[StrictStr]] = Field(default=None, alias="Passwords")
    passwords_param: Optional[Params] = Field(default=None, alias="PasswordsParam")
    usernames: Optional[List[StrictStr]] = Field(default=None, alias="Usernames")
    usernames_param: Optional[Params] = Field(default=None, alias="UsernamesParam")
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["AuthMethod", "AuthParam", "CertificateFile", "KeyFile", "KeyFilePassword", "Passwords", "PasswordsParam", "Usernames", "UsernamesParam", "links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auth_param
        if self.auth_param:
            _dict['AuthParam'] = self.auth_param.to_dict()
        # override the default output from pydantic by calling `to_dict()` of certificate_file
        if self.certificate_file:
            _dict['CertificateFile'] = self.certificate_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of key_file
        if self.key_file:
            _dict['KeyFile'] = self.key_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of passwords_param
        if self.passwords_param:
            _dict['PasswordsParam'] = self.passwords_param.to_dict()
        # override the default output from pydantic by calling `to_dict()` of usernames_param
        if self.usernames_param:
            _dict['UsernamesParam'] = self.usernames_param.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "AuthMethod": obj.get("AuthMethod"),
                        "AuthParam": Params.from_dict(obj["AuthParam"]) if obj.get("AuthParam") is not None else None,
                        "CertificateFile": Params.from_dict(obj["CertificateFile"]) if obj.get("CertificateFile") is not None else None,
                        "KeyFile": Params.from_dict(obj["KeyFile"]) if obj.get("KeyFile") is not None else None,
                        "KeyFilePassword": obj.get("KeyFilePassword"),
                        "Passwords": obj.get("Passwords"),
                        "PasswordsParam": Params.from_dict(obj["PasswordsParam"]) if obj.get("PasswordsParam") is not None else None,
                        "Usernames": obj.get("Usernames"),
                        "UsernamesParam": Params.from_dict(obj["UsernamesParam"]) if obj.get("UsernamesParam") is not None else None,
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


